/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.authdispatcher;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import de.adorsys.oauth.authdispatcher.AuthenticatorMatcher;
import de.adorsys.oauth.authdispatcher.FixedServletUtils;
import de.adorsys.oauth.authdispatcher.matcher.BasicAuthAuthenticatorMatcher;
import de.adorsys.oauth.authdispatcher.matcher.FormAuthAuthenticatorMatcher;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.management.ObjectName;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthenticationDispatcher
extends ValveBase
implements PolicyContextHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthAuthenticationDispatcher.class);
    private List<AuthenticatorMatcher> matchers = this.resolveMatcher();
    private static final String[] SUPPORTED_CONTEXT = new String[]{HttpServletRequest.class.getName(), HttpServletResponse.class.getName(), AuthorizationRequest.class.getName(), TokenRequest.class.getName()};
    private static ThreadLocal<Map<String, Object>> contextData = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    public OAuthAuthenticationDispatcher() {
        for (String key : SUPPORTED_CONTEXT) {
            try {
                PolicyContext.registerHandler((String)key, (PolicyContextHandler)this, (boolean)false);
            }
            catch (Exception e) {
                LOG.debug(e.getClass().getSimpleName() + " " + e.getMessage());
            }
        }
    }

    public void setNext(Valve valve) {
        super.setNext(valve);
        for (AuthenticatorMatcher authenticatorMatcher : this.matchers) {
            for (ValveBase valveBase : authenticatorMatcher.valves()) {
                valveBase.setNext(valve);
            }
        }
    }

    public void setContainer(Container container) {
        super.setContainer(container);
        for (AuthenticatorMatcher authenticatorMatcher : this.matchers) {
            for (ValveBase valveBase : authenticatorMatcher.valves()) {
                valveBase.setContainer(container);
            }
        }
    }

    public void setController(ObjectName controller) {
        super.setContainer(this.container);
        for (AuthenticatorMatcher authenticatorMatcher : this.matchers) {
            for (ValveBase valveBase : authenticatorMatcher.valves()) {
                valveBase.setController(controller);
            }
        }
    }

    public void setObjectName(ObjectName oname) {
        super.setContainer(this.container);
        for (AuthenticatorMatcher authenticatorMatcher : this.matchers) {
            for (ValveBase valveBase : authenticatorMatcher.valves()) {
                valveBase.setObjectName(oname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Principal principal = request.getPrincipal();
        if (principal != null) {
            this.getNext().invoke(request, response);
            return;
        }
        request.setCharacterEncoding("utf-8");
        request.getParameterNames();
        HTTPRequest httpRequest = FixedServletUtils.createHTTPRequest((HttpServletRequest)request);
        AuthorizationRequest authorizationRequest = this.resolveAuthorizationRequest(httpRequest);
        TokenRequest tokenRequest = this.resolveTokenRequest(httpRequest);
        this.store(HttpServletRequest.class.getName(), request).store(HttpServletResponse.class.getName(), response).store(AuthorizationRequest.class.getName(), authorizationRequest).store(TokenRequest.class.getName(), tokenRequest);
        String authenticator = null;
        try {
            for (AuthenticatorMatcher authenticatorMatcher : this.matchers) {
                ValveBase valveBase = authenticatorMatcher.match((HttpServletRequest)request, authorizationRequest);
                if (valveBase == null) continue;
                authenticator = authenticatorMatcher.getClass().getSimpleName();
                valveBase.invoke(request, response);
                LOG.debug("use {}, principal = {}", (Object)authenticator, (Object)request.getPrincipal());
                return;
            }
            LOG.debug("no authentificator found for {}", (Object)request.getDecodedRequestURI());
        }
        catch (Exception e) {
            LOG.error("error during calling {}: {} {}", new Object[]{authenticator, e.getClass().getSimpleName(), e.getMessage()});
        }
        finally {
            for (String key : SUPPORTED_CONTEXT) {
                contextData.get().remove(key);
            }
        }
        this.getNext().invoke(request, response);
    }

    private OAuthAuthenticationDispatcher store(String key, Object value) {
        if (value != null) {
            contextData.get().put(key, value);
        }
        return this;
    }

    private List<AuthenticatorMatcher> resolveMatcher() {
        ArrayList<AuthenticatorMatcher> list = new ArrayList<AuthenticatorMatcher>();
        try {
            ServiceLoader<AuthenticatorMatcher> loader = ServiceLoader.load(AuthenticatorMatcher.class);
            for (AuthenticatorMatcher matcher : loader) {
                list.add(matcher);
            }
        }
        catch (Exception e) {
            LOG.error(e.getClass().getSimpleName() + " " + e.getMessage());
        }
        if (list.isEmpty()) {
            list.add(new FormAuthAuthenticatorMatcher());
            list.add(new BasicAuthAuthenticatorMatcher());
        }
        return list;
    }

    private AuthorizationRequest resolveAuthorizationRequest(HTTPRequest httpRequest) {
        try {
            return AuthorizationRequest.parse((HTTPRequest)httpRequest);
        }
        catch (Exception e) {
            try {
                return AuthorizationRequest.parse((String)httpRequest.getQuery());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private TokenRequest resolveTokenRequest(HTTPRequest httpRequest) {
        try {
            return TokenRequest.parse((HTTPRequest)httpRequest);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        return contextData.get().get(key);
    }

    public String[] getKeys() throws PolicyContextException {
        return new String[]{HttpServletRequest.class.getName(), HttpServletResponse.class.getName()};
    }

    public boolean supports(String key) throws PolicyContextException {
        for (String supported : SUPPORTED_CONTEXT) {
            if (!supported.equals(key)) continue;
            return true;
        }
        return false;
    }
}

