/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.xs2a.pis;

import de.adorsys.multibanking.domain.AbstractScaTransaction;
import de.adorsys.multibanking.domain.BulkPayment;
import de.adorsys.multibanking.domain.FutureSinglePayment;
import de.adorsys.multibanking.domain.RawSepaPayment;
import de.adorsys.multibanking.domain.SinglePayment;
import de.adorsys.multibanking.xs2a.error.XS2AClientException;
import java.util.Arrays;

public enum PaymentServiceType {
    SINGLE("payments", SinglePayment.class),
    BULK("bulk-payments", BulkPayment.class),
    PERIODIC("periodic-payments", FutureSinglePayment.class);

    private String type;
    private Class<? extends AbstractScaTransaction> clazz;

    private PaymentServiceType(String type, Class<? extends AbstractScaTransaction> clazz) {
        this.type = type;
        this.clazz = clazz;
    }

    public String getType() {
        return this.type;
    }

    public Class<? extends AbstractScaTransaction> getClazz() {
        return this.clazz;
    }

    public static PaymentServiceType resolve(String service) {
        return Arrays.stream(PaymentServiceType.values()).filter(s -> s.type.equalsIgnoreCase(service)).findFirst().orElseThrow(() -> new XS2AClientException(service + " service type not supported by the system"));
    }

    public static <P extends AbstractScaTransaction> PaymentServiceType resolve(P payment) {
        if (payment == null) {
            throw new XS2AClientException("Payment object can't be null");
        }
        if (payment instanceof RawSepaPayment) {
            if (payment.getRawData() == null) {
                throw new XS2AClientException("Payment body is absent");
            }
            return PaymentServiceType.resolve(((RawSepaPayment)payment).getService());
        }
        return Arrays.stream(PaymentServiceType.values()).filter(s -> s.clazz == payment.getClass()).findFirst().orElseThrow(() -> new XS2AClientException(payment.getClass().getName() + " service class not supported by the system"));
    }
}

