/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.xs2a;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.logging.HttpLoggingInterceptor;
import de.adorsys.multibanking.domain.AbstractScaTransaction;
import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.TanChallenge;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.AuthenticatePsuRequest;
import de.adorsys.multibanking.domain.request.CreateConsentRequest;
import de.adorsys.multibanking.domain.request.LoadAccountInformationRequest;
import de.adorsys.multibanking.domain.request.LoadBalanceRequest;
import de.adorsys.multibanking.domain.request.LoadBookingsRequest;
import de.adorsys.multibanking.domain.request.SubmitAuthorizationCodeRequest;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.response.InitiatePaymentResponse;
import de.adorsys.multibanking.domain.response.LoadAccountInformationResponse;
import de.adorsys.multibanking.domain.response.LoadBookingsResponse;
import de.adorsys.multibanking.domain.response.ScaMethodsResponse;
import de.adorsys.multibanking.domain.response.SubmitAuthorizationCodeResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.xs2a.MissingConsentException;
import de.adorsys.multibanking.xs2a.XS2AMapping;
import de.adorsys.multibanking.xs2a.error.XS2AClientException;
import de.adorsys.multibanking.xs2a.executor.AbstractUpdateRequestExecutor;
import de.adorsys.multibanking.xs2a.executor.ConsentUpdateRequestExecutor;
import de.adorsys.multibanking.xs2a.executor.PaymentUpdateRequestExecutor;
import de.adorsys.multibanking.xs2a.executor.UpdateRequestExecutor;
import de.adorsys.multibanking.xs2a.model.Xs2aTanSubmit;
import de.adorsys.multibanking.xs2a.pis.PaymentInitiationBuilderStrategy;
import de.adorsys.multibanking.xs2a.pis.PaymentInitiationBuilderStrategyImpl;
import de.adorsys.multibanking.xs2a.pis.PaymentProductType;
import de.adorsys.multibanking.xs2a.pis.PaymentServiceType;
import de.adorsys.psd2.client.ApiClient;
import de.adorsys.psd2.client.ApiException;
import de.adorsys.psd2.client.api.AccountInformationServiceAisApi;
import de.adorsys.psd2.client.api.PaymentInitiationServicePisApi;
import de.adorsys.psd2.client.model.AccountAccess;
import de.adorsys.psd2.client.model.AccountList;
import de.adorsys.psd2.client.model.AccountReference;
import de.adorsys.psd2.client.model.BalanceType;
import de.adorsys.psd2.client.model.ConsentInformationResponse200Json;
import de.adorsys.psd2.client.model.Consents;
import de.adorsys.psd2.client.model.ConsentsResponse201;
import de.adorsys.psd2.client.model.PsuData;
import de.adorsys.psd2.client.model.ReadAccountBalanceResponse200;
import de.adorsys.psd2.client.model.SelectPsuAuthenticationMethod;
import de.adorsys.psd2.client.model.StartScaprocessResponse;
import de.adorsys.psd2.client.model.TransactionsResponse200Json;
import de.adorsys.psd2.client.model.UpdatePsuAuthentication;
import domain.Xs2aBankApiUser;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.lang3.StringUtils;
import org.iban4j.Iban;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XS2ABanking
implements OnlineBankingService {
    public static final String PSU_IP_ADDRESS = "127.0.0.1";
    static final String SCA_AUTHENTICATION_METHOD_ID = "authenticationMethodId";
    static final String SCA_NAME = "name";
    static final String SCA_AUTHENTICATION_VERSION = "authenticationVersion";
    static final String SCA_EXPLANATION = "explanation";
    static final String SCA_METHODS = "scaMethods";
    static final String CHALLENGE_DATA = "data";
    static final String CHALLENGE_OTP_FORMAT = "otpFormat";
    static final String CHALLENGE_ADDITIONAL_INFORMATION = "additionalInformation";
    static final String CHALLENGE = "challengeData";
    private static final Logger logger = LoggerFactory.getLogger(XS2ABanking.class);
    private SSLSocketFactory sslSocketFactory;
    private PaymentInitiationBuilderStrategy initiationBuilderStrategy = new PaymentInitiationBuilderStrategyImpl();

    public XS2ABanking() {
        this(XS2ABanking.defaultSslSocketFactory());
    }

    public XS2ABanking(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    private static SSLSocketFactory defaultSslSocketFactory() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return sslContext.getSocketFactory();
    }

    private static BankAccount toBankAccount(AccountReference reference) {
        String iban = reference.getIban();
        BankAccount bankAccount = new BankAccount();
        bankAccount.setIban(iban);
        bankAccount.setAccountNumber(Iban.valueOf((String)iban).getAccountNumber());
        bankAccount.setBalances(new BalancesReport());
        return bankAccount;
    }

    public BankApi bankApi() {
        return BankApi.XS2A;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(String bankingUrl, BankAccess bankAccess, String pin) {
        return null;
    }

    public void removeUser(String bankingUrl, BankApiUser bankApiUser) {
        throw new UnsupportedOperationException();
    }

    public ScaMethodsResponse authenticatePsu(String bankingUrl, AuthenticatePsuRequest authenticatePsuRequest) {
        ApiClient apiClient = this.createApiClient(bankingUrl);
        if (authenticatePsuRequest.getPaymentId() != null && authenticatePsuRequest.getConsentId() != null) {
            throw new IllegalArgumentException("Either payment or consent id should be set");
        }
        if (authenticatePsuRequest.getPaymentId() != null) {
            return this.authenticatePsuForPayment(authenticatePsuRequest, apiClient);
        }
        if (authenticatePsuRequest.getConsentId() != null) {
            return this.authenticatePsuForAccountInformationConsent(authenticatePsuRequest, apiClient);
        }
        throw new IllegalArgumentException("Neither payment nor consent id was set");
    }

    private ScaMethodsResponse authenticatePsuForPayment(AuthenticatePsuRequest authenticatePsuRequest, ApiClient apiClient) {
        PaymentInitiationServicePisApi service = this.createPaymentInitiationServicePisApi(apiClient);
        UUID xRequestId = UUID.randomUUID();
        String paymentId = authenticatePsuRequest.getPaymentId();
        String corporateId = authenticatePsuRequest.getCustomerId();
        String psuId = authenticatePsuRequest.getLogin();
        String password = authenticatePsuRequest.getPin();
        UpdatePsuAuthentication psuBody = this.buildUpdatePsuAuthorisationBody(password);
        try {
            StartScaprocessResponse response = service.startPaymentAuthorisation(authenticatePsuRequest.getPaymentService(), authenticatePsuRequest.getPaymentProduct(), paymentId, xRequestId, psuId, null, null, null, null, null, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null, null);
            String authorisationId = this.getAuthorizationId(response);
            Map updatePsu = (Map)service.updatePaymentPsuData(authenticatePsuRequest.getPaymentService(), authenticatePsuRequest.getPaymentProduct(), paymentId, authorisationId, xRequestId, (Object)psuBody, null, null, null, psuId, null, corporateId, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null, null);
            return this.buildPsuAuthenticationResponse(updatePsu, authorisationId);
        }
        catch (ApiException e) {
            logger.error("Authorise PSU failed", (Throwable)e);
            throw new XS2AClientException(e);
        }
    }

    PaymentInitiationServicePisApi createPaymentInitiationServicePisApi(ApiClient apiClient) {
        return new PaymentInitiationServicePisApi(apiClient);
    }

    private ScaMethodsResponse authenticatePsuForAccountInformationConsent(AuthenticatePsuRequest authenticatePsuRequest, ApiClient apiClient) {
        Object response;
        StartScaprocessResponse startScaprocessResponse;
        AccountInformationServiceAisApi ais = this.createAccountInformationServiceAisApi(apiClient);
        String consentId = authenticatePsuRequest.getConsentId();
        String psuId = authenticatePsuRequest.getLogin();
        String corporatePsuId = authenticatePsuRequest.getCustomerId();
        try {
            startScaprocessResponse = ais.startConsentAuthorisation(consentId, UUID.randomUUID(), null, null, null, psuId, null, corporatePsuId, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            logger.error("Failed to start consent authorisation", (Throwable)e);
            throw new XS2AClientException(e);
        }
        String authorisationId = this.getAuthorizationId(startScaprocessResponse);
        UpdatePsuAuthentication body = this.buildUpdatePsuAuthorisationBody(authenticatePsuRequest.getPin());
        try {
            response = ais.updateConsentsPsuData(consentId, authorisationId, UUID.randomUUID(), (Object)body, null, null, null, psuId, null, corporatePsuId, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            logger.error("Failed to update consent authorisation", (Throwable)e);
            throw new XS2AClientException(e);
        }
        return this.buildPsuAuthenticationResponse((Map)response, authorisationId);
    }

    AccountInformationServiceAisApi createAccountInformationServiceAisApi(ApiClient apiClient) {
        return new AccountInformationServiceAisApi(apiClient);
    }

    private UpdatePsuAuthentication buildUpdatePsuAuthorisationBody(String password) {
        UpdatePsuAuthentication updatePsuAuthentication = new UpdatePsuAuthentication();
        updatePsuAuthentication.psuData(new PsuData().password(password));
        return updatePsuAuthentication;
    }

    private String getAuthorizationId(StartScaprocessResponse response) {
        Map links = response.getLinks();
        String link = (String)((Map)links.get("startAuthorisationWithPsuAuthentication")).get("href");
        if (StringUtils.isBlank((CharSequence)link)) {
            link = (String)((Map)links.get("startAuthorisationWithPsuIdentification")).get("href");
        }
        if (StringUtils.isNotBlank((CharSequence)link)) {
            int index = link.lastIndexOf(47) + 1;
            return link.substring(index);
        }
        throw new XS2AClientException("authorisation id was not found in the response");
    }

    private ScaMethodsResponse buildPsuAuthenticationResponse(Map<String, Object> response, String authorisationId) {
        List transportTypes = response.getOrDefault(SCA_METHODS, Collections.emptyList()).stream().map(this::createTanType).collect(Collectors.toList());
        return ScaMethodsResponse.builder().authorizationId(authorisationId).tanTransportTypes(transportTypes).build();
    }

    private TanTransportType createTanType(Map<String, String> map) {
        return new TanTransportType(map.get(SCA_AUTHENTICATION_METHOD_ID), map.get(SCA_NAME), map.get(SCA_AUTHENTICATION_VERSION), map.get(SCA_EXPLANATION));
    }

    public LoadAccountInformationResponse loadBankAccounts(String bankingUrl, LoadAccountInformationRequest loadAccountInformationRequest) {
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        String consentId = this.retrieveConsentId(loadAccountInformationRequest.getBankApiUser(), null);
        try {
            AccountList accountList = ais.getAccountList(UUID.randomUUID(), consentId, Boolean.valueOf(false), null, null, null, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null);
            return LoadAccountInformationResponse.builder().bankAccounts(accountList.getAccounts().stream().map(XS2AMapping::toBankAccount).collect(Collectors.toList())).build();
        }
        catch (ApiException e) {
            throw new MultibankingException((Throwable)e);
        }
    }

    public void removeBankAccount(String bankingUrl, BankAccount bankAccount, BankApiUser bankApiUser) {
        throw new UnsupportedOperationException();
    }

    public LoadBookingsResponse loadBookings(String bankingUrl, LoadBookingsRequest loadBookingsRequest) {
        String iban = loadBookingsRequest.getBankAccount().getIban();
        String consentId = this.retrieveConsentId(loadBookingsRequest.getBankApiUser(), iban);
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        String resourceId = (String)loadBookingsRequest.getBankAccount().getExternalIdMap().get(BankApi.XS2A);
        LocalDate dateFrom = loadBookingsRequest.getDateFrom();
        LocalDate dateTo = loadBookingsRequest.getDateTo();
        try {
            TransactionsResponse200Json transactionList = ais.getTransactionList(resourceId, "booked", UUID.randomUUID(), consentId, dateFrom, dateTo, null, null, null, null, null, null, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null);
            return LoadBookingsResponse.builder().bookings(XS2AMapping.toBookings(transactionList)).build();
        }
        catch (ApiException e) {
            throw new MultibankingException((Throwable)e);
        }
    }

    public List<BankAccount> loadBalances(String bankingUrl, LoadBalanceRequest loadBalanceRequest) {
        List bankAccounts = loadBalanceRequest.getBankAccounts();
        if (bankAccounts.isEmpty()) {
            return Collections.emptyList();
        }
        if (bankAccounts.size() > 1) {
            logger.warn("Only first bank account will be processed");
        }
        BankAccount account = (BankAccount)bankAccounts.get(0);
        String accountId = (String)account.getExternalIdMap().get(BankApi.XS2A);
        UUID xRequestId = UUID.randomUUID();
        String consentId = this.retrieveConsentId(loadBalanceRequest.getBankApiUser(), account.getIban());
        AccountInformationServiceAisApi ais = this.createAccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        try {
            ReadAccountBalanceResponse200 balances = ais.getBalances(accountId, xRequestId, consentId, null, null, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null, null);
            return Collections.singletonList(this.convertToBankAccount(balances));
        }
        catch (ApiException e) {
            logger.error("Loading balances failed", (Throwable)e);
            throw new XS2AClientException(e);
        }
    }

    private String retrieveConsentId(BankApiUser bankApiUser, String iban) {
        Optional<String> consent = bankApiUser instanceof Xs2aBankApiUser ? Optional.ofNullable(((Xs2aBankApiUser)bankApiUser).getConsentId()) : Optional.ofNullable(bankApiUser.getProperties().get("consentId-" + iban));
        return consent.orElseThrow(() -> new MissingConsentException("missing consent for transactions request"));
    }

    private BankAccount convertToBankAccount(ReadAccountBalanceResponse200 balances) {
        BankAccount bankAccount = XS2ABanking.toBankAccount(balances.getAccount());
        BalancesReport balancesReport = bankAccount.getBalances();
        block4: for (de.adorsys.psd2.client.model.Balance balance : balances.getBalances()) {
            BalanceType balanceType = balance.getBalanceType();
            switch (balanceType) {
                case CLOSINGBOOKED: {
                    balancesReport.setReadyBalance(this.toMultibankingBalance(balance));
                    continue block4;
                }
                case EXPECTED: {
                    balancesReport.setUnreadyBalance(this.toMultibankingBalance(balance));
                    continue block4;
                }
            }
            logger.warn("Unexpected {} balance", (Object)balanceType);
        }
        return bankAccount;
    }

    private Balance toMultibankingBalance(de.adorsys.psd2.client.model.Balance balance) {
        BigDecimal amount = new BigDecimal(balance.getBalanceAmount().getAmount());
        String currency = balance.getBalanceAmount().getCurrency();
        LocalDate referenceDate = balance.getReferenceDate();
        return new Balance(referenceDate, amount, currency);
    }

    public boolean bankSupported(String bankCode) {
        return true;
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public InitiatePaymentResponse initiatePayment(String bankingUrl, TransactionRequest paymentRequest) {
        UUID xRequestId = UUID.randomUUID();
        AbstractScaTransaction payment = paymentRequest.getTransaction();
        PaymentProductType paymentProduct = PaymentProductType.resolve(payment.getProduct());
        PaymentServiceType paymentService = PaymentServiceType.resolve(payment);
        String contentType = "application/" + (paymentProduct.isRaw() ? "xml" : "json");
        String psuId = paymentRequest.getBankAccess().getBankLogin();
        Object paymentBody = this.initiationBuilderStrategy.resolve(paymentProduct, paymentService).buildBody(payment);
        ApiClient apiClient = this.createApiClient(bankingUrl, contentType);
        PaymentInitiationServicePisApi initiationService = this.createPaymentInitiationServicePisApi(apiClient);
        try {
            Map response = (Map)initiationService.initiatePayment(paymentBody, paymentService.getType(), paymentProduct.getType(), xRequestId, PSU_IP_ADDRESS, null, null, null, psuId, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
            return this.getInitiatePaymentResponse(response);
        }
        catch (ApiException e) {
            logger.error("Initiate payment failed", (Throwable)e);
            throw new XS2AClientException(e);
        }
    }

    public void executeTransactionWithoutSca(String bankingUrl, TransactionRequest paymentRequest) {
        throw new UnsupportedOperationException();
    }

    private InitiatePaymentResponse getInitiatePaymentResponse(Map<String, Object> response) {
        String transactionStatus = (String)response.get("transactionStatus");
        String paymentId = (String)response.get("paymentId");
        Map links = (Map)response.get("_links");
        String scaRedirect = links.get("scaRedirect") != null ? (String)((Map)links.get("scaRedirect")).get("href") : null;
        return new InitiatePaymentResponse(transactionStatus, paymentId, scaRedirect);
    }

    public AuthorisationCodeResponse requestAuthorizationCode(String bankingUrl, TransactionRequest request) {
        ApiClient apiClient = this.createApiClient(bankingUrl);
        if (request.getTransaction().getTransactionType() == AbstractScaTransaction.TransactionType.DEDICATED_CONSENT) {
            return this.requestAuthorizationCodeForAccountInformationConsent(request, apiClient);
        }
        return this.requestAuthorizationCodeForPayment(bankingUrl, request, apiClient);
    }

    private AuthorisationCodeResponse requestAuthorizationCodeForPayment(String bankingUrl, TransactionRequest paymentRequest, ApiClient apiClient) {
        PaymentInitiationServicePisApi service = this.createPaymentInitiationServicePisApi(apiClient);
        AbstractScaTransaction payment = paymentRequest.getTransaction();
        PaymentProductType paymentProduct = PaymentProductType.resolve(payment.getProduct());
        PaymentServiceType paymentService = PaymentServiceType.resolve(payment);
        String paymentId = payment.getPaymentId();
        String authorisationId = paymentRequest.getAuthorisationId();
        UUID xRequestId = UUID.randomUUID();
        String psuId = paymentRequest.getBankAccess().getBankLogin();
        String corporateId = paymentRequest.getBankAccess().getBankLogin2();
        SelectPsuAuthenticationMethod body = this.buildSelectPsuAuthenticationMethod(paymentRequest.getTanTransportType().getId());
        Xs2aTanSubmit tanSubmit = new Xs2aTanSubmit(bankingUrl, paymentId, authorisationId, psuId, corporateId);
        tanSubmit.setPaymentProduct(paymentProduct.getType());
        tanSubmit.setPaymentService(paymentService.getType());
        try {
            Map updatePsuData = (Map)service.updatePaymentPsuData(paymentService.getType(), paymentProduct.getType(), paymentId, authorisationId, xRequestId, (Object)body, null, null, null, psuId, null, corporateId, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null, null);
            return this.buildAuthorisationCodeResponse(updatePsuData, tanSubmit);
        }
        catch (ApiException e) {
            logger.error("Initiate payment failed", (Throwable)e);
            throw new XS2AClientException(e);
        }
    }

    private AuthorisationCodeResponse buildAuthorisationCodeResponse(Map<String, Object> updatePsuData, Xs2aTanSubmit tanSubmit) {
        AuthorisationCodeResponse response = new AuthorisationCodeResponse();
        response.setTanSubmit((Object)tanSubmit);
        Map map = (Map)updatePsuData.get(CHALLENGE);
        TanChallenge challenge = new TanChallenge();
        challenge.setData((String)map.get(CHALLENGE_DATA));
        challenge.setFormat((String)map.get(CHALLENGE_OTP_FORMAT));
        challenge.setTitle((String)map.get(CHALLENGE_ADDITIONAL_INFORMATION));
        response.setChallenge(challenge);
        return response;
    }

    private SelectPsuAuthenticationMethod buildSelectPsuAuthenticationMethod(String methodId) {
        SelectPsuAuthenticationMethod selectPsuAuthenticationMethod = new SelectPsuAuthenticationMethod();
        selectPsuAuthenticationMethod.setAuthenticationMethodId(methodId);
        return selectPsuAuthenticationMethod;
    }

    private AuthorisationCodeResponse requestAuthorizationCodeForAccountInformationConsent(TransactionRequest request, ApiClient apiClient) {
        Object response;
        AccountInformationServiceAisApi ais = this.createAccountInformationServiceAisApi(apiClient);
        String consentId = request.getTransaction().getOrderId();
        String authorisationId = request.getAuthorisationId();
        SelectPsuAuthenticationMethod body = this.buildSelectPsuAuthenticationMethod(request.getTanTransportType().getId());
        String psuId = request.getBankAccess().getBankLogin();
        String psuCorporateId = request.getBankAccess().getBankLogin2();
        try {
            response = ais.updateConsentsPsuData(consentId, authorisationId, UUID.randomUUID(), (Object)body, null, null, null, psuId, null, psuCorporateId, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            logger.error("Failed to request authorization code", (Throwable)e);
            throw new XS2AClientException(e);
        }
        return this.buildAuthorisationCodeResponse((Map)response, new Xs2aTanSubmit(apiClient.getBasePath(), consentId, authorisationId, psuId, psuCorporateId));
    }

    public SubmitAuthorizationCodeResponse submitAuthorizationCode(SubmitAuthorizationCodeRequest submitPaymentRequest) {
        Xs2aTanSubmit tanSubmit = (Xs2aTanSubmit)submitPaymentRequest.getTanSubmit();
        String bankingUrl = tanSubmit.getBankingUrl();
        ApiClient apiClient = this.createApiClient(bankingUrl);
        UpdateRequestExecutor executor = this.createUpdateRequestExecutor(submitPaymentRequest);
        Object request = executor.buildRequest(submitPaymentRequest);
        try {
            SubmitAuthorizationCodeResponse response = new SubmitAuthorizationCodeResponse();
            response.setTransactionId(executor.execute(request, apiClient));
            return response;
        }
        catch (ApiException e) {
            logger.error("Submit authorisation code failed", (Throwable)e);
            throw new XS2AClientException(e);
        }
    }

    UpdateRequestExecutor createUpdateRequestExecutor(SubmitAuthorizationCodeRequest submitPaymentRequest) {
        AbstractUpdateRequestExecutor executor = submitPaymentRequest.getSepaTransaction().getTransactionType() == AbstractScaTransaction.TransactionType.DEDICATED_CONSENT ? new ConsentUpdateRequestExecutor() : new PaymentUpdateRequestExecutor();
        return executor;
    }

    public boolean accountInformationConsentRequired() {
        return true;
    }

    public CreateConsentResponse createAccountInformationConsent(String bankingUrl, CreateConsentRequest createConsentRequest) {
        ConsentInformationResponse200Json consentInformation;
        ConsentsResponse201 response;
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        Consents consents = this.toConsents(createConsentRequest);
        BankAccess bankAccess = createConsentRequest.getBankAccess();
        try {
            response = ais.createConsent(UUID.randomUUID(), consents, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, "false", null, null, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            logger.error("Create consent failed", (Throwable)e);
            throw new XS2AClientException(e);
        }
        String consentId = response.getConsentId();
        try {
            consentInformation = ais.getConsentInformation(consentId, UUID.randomUUID(), null, null, null, PSU_IP_ADDRESS, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            logger.error("Get consent failed", (Throwable)e);
            throw new XS2AClientException(e);
        }
        Map links = response.getLinks();
        String scaRedirect = links.get("scaRedirect") != null ? (String)((Map)links.get("scaRedirect")).get("href") : null;
        return CreateConsentResponse.builder().consentId(consentId).validUntil(consentInformation.getValidUntil()).authorisationUrl(scaRedirect).build();
    }

    private Consents toConsents(CreateConsentRequest request) {
        Consents consents = new Consents();
        consents.setAccess(this.toAccountAccess(request));
        consents.setRecurringIndicator(Boolean.valueOf(request.isRecurringIndicator()));
        consents.setValidUntil(request.getValidUntil());
        consents.setFrequencyPerDay(Integer.valueOf(request.getFrequencyPerDay()));
        consents.setCombinedServiceIndicator(Boolean.valueOf(request.isCombinedServiceIndicator()));
        return consents;
    }

    private AccountAccess toAccountAccess(CreateConsentRequest request) {
        AccountAccess accountAccess = new AccountAccess();
        accountAccess.setAccounts(this.toAccountReferences(request.getAccounts()));
        accountAccess.setBalances(this.toAccountReferences(request.getBalances()));
        accountAccess.setTransactions(this.toAccountReferences(request.getTransactions()));
        return accountAccess;
    }

    private List<AccountReference> toAccountReferences(List<BankAccount> accounts) {
        ArrayList<AccountReference> accountReferences = new ArrayList<AccountReference>();
        for (BankAccount account : accounts) {
            AccountReference accountReference = new AccountReference();
            accountReference.setIban(account.getIban());
            accountReference.setCurrency(account.getCurrency());
            accountReferences.add(accountReference);
        }
        return accountReferences;
    }

    private ApiClient createApiClient(String bankingUrl, final String contentType) {
        ApiClient apiClient = new ApiClient(){

            public String selectHeaderContentType(String[] contentTypes) {
                return Optional.ofNullable(contentType).orElseGet(() -> super.selectHeaderContentType(contentTypes));
            }
        };
        OkHttpClient client = new OkHttpClient();
        client.interceptors().add(new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
        client.setReadTimeout(600L, TimeUnit.SECONDS);
        client.setSslSocketFactory(this.sslSocketFactory);
        apiClient.setHttpClient(client);
        Optional.ofNullable(bankingUrl).ifPresent(arg_0 -> ((ApiClient)apiClient).setBasePath(arg_0));
        return apiClient;
    }

    ApiClient createApiClient(String bankingUrl) {
        return this.createApiClient(bankingUrl, null);
    }
}

