/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.xs2a.pis;

import de.adorsys.multibanking.xs2a.error.XS2AClientException;
import java.util.Arrays;

public enum PaymentProductType {
    SEPA("sepa-credit-transfers"),
    INSTANT_SEPA("instant-sepa-credit-transfers"),
    TARGET_2_PAYMENTS("target-2-payments"),
    CROSS_BORDER("cross-border-credit-transfers"),
    PAIN_001_SEPA("pain.001-sepa-credit-transfers", true),
    PAIN_001_INSTANT_SEPA("pain.001-instant-sepa-credit-transfers", true),
    PAIN_001_TARGET_2_PAYMENTS("pain.001-target-2-payments", true),
    PAIN_001_CROSS_BORDER("pain.001-cross-border-credit-transfers", true);

    private String type;
    private boolean isRaw;

    private PaymentProductType(String type, boolean isRaw) {
        this.type = type;
        this.isRaw = isRaw;
    }

    private PaymentProductType(String type) {
        this(type, false);
    }

    public String getType() {
        return this.type;
    }

    public boolean isRaw() {
        return this.isRaw;
    }

    public static PaymentProductType resolve(String type) {
        return Arrays.stream(PaymentProductType.values()).filter(p -> p.type.equalsIgnoreCase(type)).findFirst().orElseThrow(() -> new XS2AClientException(type + " product type not supported by the system"));
    }
}

