/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.xs2a.executor;

import de.adorsys.multibanking.domain.request.SubmitAuthorizationCodeRequest;
import de.adorsys.multibanking.xs2a.executor.UpdateRequestExecutor;
import de.adorsys.multibanking.xs2a.model.XS2AUpdateRequest;
import de.adorsys.multibanking.xs2a.model.Xs2aTanSubmit;
import de.adorsys.psd2.client.model.TransactionAuthorisation;
import java.util.UUID;

abstract class AbstractUpdateRequestExecutor<T extends XS2AUpdateRequest>
implements UpdateRequestExecutor<T> {
    AbstractUpdateRequestExecutor() {
    }

    @Override
    public final T buildRequest(SubmitAuthorizationCodeRequest request) {
        Xs2aTanSubmit tanSubmit = (Xs2aTanSubmit)request.getTanSubmit();
        T updateRequest = this.createRequest(tanSubmit);
        ((XS2AUpdateRequest)updateRequest).setAuthorisationId(tanSubmit.getAuthorisationId());
        ((XS2AUpdateRequest)updateRequest).setPsuId(tanSubmit.getPsuId());
        ((XS2AUpdateRequest)updateRequest).setPsuCorporateId(tanSubmit.getPsuCorporateId());
        ((XS2AUpdateRequest)updateRequest).setPsuIpAddress("127.0.0.1");
        ((XS2AUpdateRequest)updateRequest).setRequestId(UUID.randomUUID());
        ((XS2AUpdateRequest)updateRequest).setBody(this.buildTransactionAuthorisation(request.getTan()));
        return updateRequest;
    }

    abstract T createRequest(Xs2aTanSubmit var1);

    private TransactionAuthorisation buildTransactionAuthorisation(String tan) {
        TransactionAuthorisation transactionAuthorisation = new TransactionAuthorisation();
        transactionAuthorisation.setScaAuthenticationData(tan);
        return transactionAuthorisation;
    }
}

