/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.xs2a.pis.sepa;

import de.adorsys.multibanking.domain.AbstractScaTransaction;
import de.adorsys.multibanking.domain.FutureSinglePayment;
import de.adorsys.multibanking.domain.SinglePayment;
import de.adorsys.multibanking.xs2a.pis.sepa.AbstractPaymentInitiationBodyBuilder;
import de.adorsys.psd2.client.model.DayOfExecution;
import de.adorsys.psd2.client.model.PeriodicPaymentInitiationSctJson;
import java.time.LocalDate;

public class SepaPeriodicPaymentInitiationBodyBuilder
extends AbstractPaymentInitiationBodyBuilder<PeriodicPaymentInitiationSctJson> {
    @Override
    public PeriodicPaymentInitiationSctJson buildBody(AbstractScaTransaction transaction) {
        FutureSinglePayment paymentBodyObj = (FutureSinglePayment)transaction;
        PeriodicPaymentInitiationSctJson periodic = new PeriodicPaymentInitiationSctJson();
        periodic.setDebtorAccount(this.buildDebtorAccountReference((AbstractScaTransaction)paymentBodyObj));
        periodic.setCreditorAccount(this.buildCreditorAccountReference((SinglePayment)paymentBodyObj));
        periodic.setInstructedAmount(this.buildAmount((SinglePayment)paymentBodyObj));
        periodic.setCreditorName(paymentBodyObj.getReceiver());
        periodic.setRemittanceInformationUnstructured(paymentBodyObj.getPurpose());
        LocalDate executionDate = paymentBodyObj.getExecutionDate();
        periodic.setDayOfExecution(DayOfExecution.fromValue((String)String.valueOf(executionDate.getDayOfMonth())));
        return periodic;
    }
}

