/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.logging.HttpLoggingInterceptor;
import de.adorsys.psd2.client.ApiClient;
import de.adorsys.psd2.client.ApiException;
import de.adorsys.psd2.client.api.AccountInformationServiceAisApi;
import de.adorsys.psd2.client.api.PaymentInitiationServicePisApi;
import de.adorsys.psd2.client.model.AccountAccess;
import de.adorsys.psd2.client.model.AccountList;
import de.adorsys.psd2.client.model.AccountReference;
import de.adorsys.psd2.client.model.Amount;
import de.adorsys.psd2.client.model.Consents;
import de.adorsys.psd2.client.model.ConsentsResponse201;
import de.adorsys.psd2.client.model.PaymentInitiationSctJson;
import de.adorsys.psd2.client.model.PsuData;
import de.adorsys.psd2.client.model.SelectPsuAuthenticationMethod;
import de.adorsys.psd2.client.model.StartScaprocessResponse;
import de.adorsys.psd2.client.model.TransactionAuthorisation;
import de.adorsys.psd2.client.model.TransactionsResponse200Json;
import de.adorsys.psd2.client.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.MissingConsentException;
import de.adorsys.xs2a.XS2AMapping;
import de.adorsys.xs2a.error.XS2AClientException;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.SinglePayment;
import domain.TanTransportType;
import domain.request.AuthenticatePsuRequest;
import domain.request.CreateConsentRequest;
import domain.request.LoadAccountInformationRequest;
import domain.request.LoadBalanceRequest;
import domain.request.LoadBookingsRequest;
import domain.request.SubmitAuthorizationCodeRequest;
import domain.request.TransactionRequest;
import domain.response.AuthorisationCodeResponse;
import domain.response.InitiatePaymentResponse;
import domain.response.LoadAccountInformationResponse;
import domain.response.LoadBookingsResponse;
import domain.response.ScaMethodsResponse;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spi.OnlineBankingService;

public class XS2ABanking
implements OnlineBankingService {
    private static final Logger logger = LoggerFactory.getLogger(XS2ABanking.class);
    static final String PS_UIP_ADDRESS = "127.0.0.1";
    static final String SINGLE_PAYMENT_SERVICE = "payments";
    static final String SEPA_CREDIT_TRANSFERS = "sepa-credit-transfers";
    static final String SCA_AUTHENTICATION_METHOD_ID = "authenticationMethodId";
    static final String SCA_NAME = "name";
    static final String SCA_AUTHENTICATION_VERSION = "authenticationVersion";
    static final String SCA_EXPLANATION = "explanation";
    static final String SCA_METHODS = "scaMethods";

    public BankApi bankApi() {
        return BankApi.XS2A;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return true;
    }

    public BankApiUser registerUser(String bankingUrl, BankAccess bankAccess, String pin) {
        AccountAccess accountAccess = new AccountAccess();
        accountAccess.setAllPsd2(AccountAccess.AllPsd2Enum.ALLACCOUNTS);
        Consents consents = new Consents();
        consents.setValidUntil(LocalDate.now().plusDays(30L));
        consents.setFrequencyPerDay(Integer.valueOf(100));
        consents.setAccess(accountAccess);
        consents.setRecurringIndicator(Boolean.valueOf(true));
        try {
            BankApiUser bankApiUser = new BankApiUser();
            bankApiUser.setApiUserId(bankAccess.getBankLogin());
            bankApiUser.setBankApi(BankApi.XS2A);
            bankApiUser.setProperties(new HashMap());
            bankApiUser.getProperties().put("allAccountsConsentId", this.createConsent(bankingUrl, bankAccess, pin, consents).getConsentId());
            return bankApiUser;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUser(String bankingUrl, BankApiUser bankApiUser) {
    }

    public ScaMethodsResponse authenticatePsu(String bankingUrl, AuthenticatePsuRequest authenticatePsuRequest) {
        ApiClient apiClient = this.createApiClient(bankingUrl);
        PaymentInitiationServicePisApi service = this.createPaymentInitiationServicePisApi(apiClient);
        UUID xRequestId = UUID.randomUUID();
        String paymentId = authenticatePsuRequest.getPaymentId();
        String corporateId = authenticatePsuRequest.getCustomerId();
        String psuId = authenticatePsuRequest.getLogin();
        String password = authenticatePsuRequest.getPin();
        UpdatePsuAuthentication psuBody = this.buildUpdatePsuAuthorisationBody(password);
        try {
            StartScaprocessResponse response = service.startPaymentAuthorisation(SINGLE_PAYMENT_SERVICE, SEPA_CREDIT_TRANSFERS, paymentId, xRequestId, psuId, null, null, null, null, null, null, PS_UIP_ADDRESS, null, null, null, null, null, null, null, null, null);
            String authorisationId = this.getAuthorizationId(response);
            Map updatePsu = (Map)service.updatePaymentPsuData(SINGLE_PAYMENT_SERVICE, SEPA_CREDIT_TRANSFERS, paymentId, authorisationId, xRequestId, (Object)psuBody, null, null, null, psuId, null, corporateId, null, PS_UIP_ADDRESS, null, null, null, null, null, null, null, null, null);
            return this.buildPsuAuthenticationResponse(updatePsu, authorisationId);
        }
        catch (ApiException e) {
            logger.error("Authorise PSU failed", (Throwable)e);
            throw new XS2AClientException(e);
        }
    }

    PaymentInitiationServicePisApi createPaymentInitiationServicePisApi(ApiClient apiClient) {
        return new PaymentInitiationServicePisApi(apiClient);
    }

    private UpdatePsuAuthentication buildUpdatePsuAuthorisationBody(String password) {
        UpdatePsuAuthentication updatePsuAuthentication = new UpdatePsuAuthentication();
        updatePsuAuthentication.psuData(new PsuData().password(password));
        return updatePsuAuthentication;
    }

    private String getAuthorizationId(StartScaprocessResponse response) {
        String psuAuthentication = (String)response.getLinks().get("startAuthorisationWithPsuAuthentication");
        if (StringUtils.isNotBlank((CharSequence)psuAuthentication)) {
            int index = psuAuthentication.lastIndexOf(47) + 1;
            return psuAuthentication.substring(index);
        }
        return null;
    }

    private ScaMethodsResponse buildPsuAuthenticationResponse(Map<String, Object> response, String authorisationId) {
        List transportTypes = ((List)response.getOrDefault(SCA_METHODS, Collections.EMPTY_LIST)).stream().map(this::createTanType).collect(Collectors.toList());
        return ScaMethodsResponse.builder().authorizationId(authorisationId).tanTransportTypes(transportTypes).build();
    }

    private TanTransportType createTanType(Map<String, String> map) {
        return new TanTransportType(map.get(SCA_AUTHENTICATION_METHOD_ID), map.get(SCA_NAME), map.get(SCA_AUTHENTICATION_VERSION), map.get(SCA_EXPLANATION));
    }

    public LoadAccountInformationResponse loadBankAccounts(String bankingUrl, LoadAccountInformationRequest loadAccountInformationRequest) {
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        String consentId = (String)loadAccountInformationRequest.getBankApiUser().getProperties().get("allAccountsConsentId");
        try {
            AccountList accountList = ais.getAccountList(UUID.randomUUID(), consentId, Boolean.valueOf(false), null, null, null, null, PS_UIP_ADDRESS, null, null, null, null, null, null, null, null);
            return LoadAccountInformationResponse.builder().bankAccounts(accountList.getAccounts().stream().map(XS2AMapping::toBankAccount).collect(Collectors.toList())).build();
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeBankAccount(String bankingUrl, BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public LoadBookingsResponse loadBookings(String bankingUrl, LoadBookingsRequest loadBookingsRequest) {
        String consentId = (String)Optional.ofNullable(loadBookingsRequest.getBankApiUser().getProperties().get("consentId-" + loadBookingsRequest.getBankAccount().getIban())).orElseThrow(() -> new MissingConsentException("missing consent for transactions request"));
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        String resourceId = (String)loadBookingsRequest.getBankAccount().getExternalIdMap().get(BankApi.XS2A);
        try {
            TransactionsResponse200Json transactionList = ais.getTransactionList(resourceId, "booked", UUID.randomUUID(), consentId, null, null, null, null, null, null, null, null, null, PS_UIP_ADDRESS, null, null, null, null, null, null, null, null);
            return LoadBookingsResponse.builder().bookings(XS2AMapping.toBookings(transactionList)).build();
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public List<BankAccount> loadBalances(String bankingUrl, LoadBalanceRequest loadBalanceRequest) {
        return null;
    }

    public boolean bankSupported(String bankCode) {
        return true;
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public InitiatePaymentResponse initiatePayment(String bankingUrl, TransactionRequest paymentRequest) {
        String contentType;
        String paymentProduct;
        Object paymentBody;
        UUID xRequestId = UUID.randomUUID();
        Optional<String> rawData = Optional.ofNullable(paymentRequest.getTransaction().getRawData());
        if (rawData.isPresent()) {
            paymentBody = rawData.get().getBytes();
            paymentProduct = "pain.001-sepa-credit-transfers";
            contentType = "application/xml";
        } else {
            paymentBody = this.convertToPaymentInitiation(paymentRequest);
            paymentProduct = SEPA_CREDIT_TRANSFERS;
            contentType = "application/json";
        }
        ApiClient apiClient = this.createApiClient(bankingUrl, contentType);
        PaymentInitiationServicePisApi initiationService = this.createPaymentInitiationServicePisApi(apiClient);
        try {
            Map response = (Map)initiationService.initiatePayment(paymentBody, SINGLE_PAYMENT_SERVICE, paymentProduct, xRequestId, PS_UIP_ADDRESS, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
            return this.getInitiatePaymentResponse(response);
        }
        catch (ApiException e) {
            logger.error("Initiate payment failed", (Throwable)e);
            throw new XS2AClientException(e);
        }
    }

    private PaymentInitiationSctJson convertToPaymentInitiation(TransactionRequest paymentRequest) {
        SinglePayment paymentBodyObj = (SinglePayment)paymentRequest.getTransaction();
        PaymentInitiationSctJson paymentInitiation = new PaymentInitiationSctJson();
        AccountReference debtorAccountReference = new AccountReference();
        debtorAccountReference.setIban(paymentBodyObj.getDebtorBankAccount().getIban());
        AccountReference creditorAccountReference = new AccountReference();
        creditorAccountReference.setIban(paymentBodyObj.getReceiverIban());
        Amount amount = new Amount();
        amount.setAmount(paymentBodyObj.getAmount().toString());
        amount.setCurrency("EUR");
        paymentInitiation.setDebtorAccount(debtorAccountReference);
        paymentInitiation.setCreditorAccount(creditorAccountReference);
        paymentInitiation.setInstructedAmount(amount);
        paymentInitiation.setCreditorName(paymentBodyObj.getReceiver());
        paymentInitiation.setRemittanceInformationUnstructured(paymentBodyObj.getPurpose());
        return paymentInitiation;
    }

    private InitiatePaymentResponse getInitiatePaymentResponse(Map<String, Object> response) {
        String transactionStatus = (String)response.get("transactionStatus");
        String paymentId = (String)response.get("paymentId");
        Map links = (Map)response.get("_links");
        return new InitiatePaymentResponse(transactionStatus, paymentId, links);
    }

    public AuthorisationCodeResponse requestAuthorizationCode(String bankingUrl, TransactionRequest paymentRequest) {
        return null;
    }

    public String submitAuthorizationCode(SubmitAuthorizationCodeRequest submitPaymentRequest) {
        return null;
    }

    public boolean accountInformationConsentRequired(BankApiUser bankApiUser, String accountReference) {
        return !Optional.ofNullable(bankApiUser.getProperties().get("consentId-" + accountReference)).isPresent();
    }

    public void createAccountInformationConsent(String bankingUrl, CreateConsentRequest startScaRequest) {
        String newConsent = this.createDedicatedAccountConsent(bankingUrl, startScaRequest, startScaRequest.getBankAccess());
        startScaRequest.getBankApiUser().getProperties().put("consentId-" + startScaRequest.getIban(), newConsent);
    }

    private String createDedicatedAccountConsent(String bankingUrl, CreateConsentRequest startScaRequest, BankAccess bankAccess) {
        Consents consents = new Consents();
        consents.setValidUntil(LocalDate.now().plusYears(1L));
        consents.setFrequencyPerDay(Integer.valueOf(100));
        AccountReference accountReferenceIban = new AccountReference();
        accountReferenceIban.setIban(startScaRequest.getIban());
        accountReferenceIban.setCurrency("EUR");
        List<AccountReference> accounts = Arrays.asList(accountReferenceIban);
        AccountAccess accountAccess = new AccountAccess();
        accountAccess.setTransactions(accounts);
        accountAccess.setAccounts(accounts);
        accountAccess.setBalances(accounts);
        consents.setAccess(accountAccess);
        consents.setRecurringIndicator(Boolean.valueOf(true));
        try {
            return this.createConsent(bankingUrl, bankAccess, startScaRequest.getPin(), consents).getConsentId();
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    private ConsentsResponse201 createConsent(String bankingUrl, BankAccess bankAccess, String pin, Consents consents) throws ApiException {
        UUID session = UUID.randomUUID();
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        ConsentsResponse201 consent = ais.createConsent(session, consents, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, "false", null, null, null, PS_UIP_ADDRESS, null, null, null, null, null, null, null, null, null);
        StartScaprocessResponse startScaprocessResponse = ais.startConsentAuthorisation(consent.getConsentId(), session, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, null, null, null, null, null, null, null, null, null, null);
        String authorisationLink = startScaprocessResponse.getLinks().get("startAuthorisationWithPsuAuthentication").toString();
        String authorizationId = StringUtils.substringAfterLast((String)authorisationLink, (String)"/");
        UpdatePsuAuthentication updatePsuAuthentication = this.buildUpdatePsuAuthorisationBody(pin);
        Map updatePsuResponse = (Map)ais.updateConsentsPsuData(consent.getConsentId(), authorizationId, session, (Object)updatePsuAuthentication, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, null, null, null, null, null, null, null, null, null, null);
        List scaMethods = (List)updatePsuResponse.get(SCA_METHODS);
        String otp = (String)scaMethods.stream().map(x -> x.get(SCA_AUTHENTICATION_METHOD_ID)).filter(x -> "901".equals(x)).findFirst().get();
        SelectPsuAuthenticationMethod selectPsuAuthenticationMethod = new SelectPsuAuthenticationMethod();
        selectPsuAuthenticationMethod.setAuthenticationMethodId(otp);
        updatePsuResponse = (Map)ais.updateConsentsPsuData(consent.getConsentId(), authorizationId, session, (Object)selectPsuAuthenticationMethod, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, PS_UIP_ADDRESS, null, null, null, null, null, null, null, null, null);
        TransactionAuthorisation transactionAuthorisation = new TransactionAuthorisation();
        transactionAuthorisation.setScaAuthenticationData("dontcare");
        updatePsuResponse = (Map)ais.updateConsentsPsuData(consent.getConsentId(), authorizationId, session, (Object)transactionAuthorisation, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, PS_UIP_ADDRESS, null, null, null, null, null, null, null, null, null);
        return consent;
    }

    private ApiClient createApiClient(String bankingUrl, final String contentType) {
        ApiClient apiClient = new ApiClient(){

            public String selectHeaderContentType(String[] contentTypes) {
                return Optional.ofNullable(contentType).orElseGet(() -> super.selectHeaderContentType(contentTypes));
            }
        };
        OkHttpClient client = new OkHttpClient();
        client.interceptors().add(new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
        client.setReadTimeout(600L, TimeUnit.SECONDS);
        apiClient.setHttpClient(client);
        Optional.ofNullable(bankingUrl).ifPresent(url -> apiClient.setBasePath(url));
        return apiClient;
    }

    ApiClient createApiClient(String bankingUrl) {
        return this.createApiClient(bankingUrl, null);
    }
}

