/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.logging.HttpLoggingInterceptor;
import de.adorsys.psd2.client.ApiClient;
import de.adorsys.psd2.client.ApiException;
import de.adorsys.psd2.client.api.AccountInformationServiceAisApi;
import de.adorsys.psd2.client.model.AccountAccess;
import de.adorsys.psd2.client.model.AccountList;
import de.adorsys.psd2.client.model.AccountReference;
import de.adorsys.psd2.client.model.Consents;
import de.adorsys.psd2.client.model.ConsentsResponse201;
import de.adorsys.psd2.client.model.PsuData;
import de.adorsys.psd2.client.model.SelectPsuAuthenticationMethod;
import de.adorsys.psd2.client.model.StartScaprocessResponse;
import de.adorsys.psd2.client.model.TransactionAuthorisation;
import de.adorsys.psd2.client.model.TransactionsResponse200Json;
import de.adorsys.psd2.client.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.MissingConsentException;
import de.adorsys.xs2a.XS2AMapping;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.request.AuthenticatePsuRequest;
import domain.request.CreateConsentRequest;
import domain.request.LoadAccountInformationRequest;
import domain.request.LoadBalanceRequest;
import domain.request.LoadBookingsRequest;
import domain.request.SubmitAuthorizationCodeRequest;
import domain.request.TransactionRequest;
import domain.response.LoadAccountInformationResponse;
import domain.response.LoadBookingsResponse;
import domain.response.ScaMethodsResponse;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import spi.OnlineBankingService;

public class XS2ABanking
implements OnlineBankingService {
    public BankApi bankApi() {
        return BankApi.XS2A;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return true;
    }

    public BankApiUser registerUser(String bankingUrl, BankAccess bankAccess, String pin) {
        AccountAccess accountAccess = new AccountAccess();
        accountAccess.setAllPsd2(AccountAccess.AllPsd2Enum.ALLACCOUNTS);
        Consents consents = new Consents();
        consents.setValidUntil(LocalDate.now().plusDays(30L));
        consents.setFrequencyPerDay(Integer.valueOf(100));
        consents.setAccess(accountAccess);
        consents.setRecurringIndicator(Boolean.valueOf(true));
        try {
            BankApiUser bankApiUser = new BankApiUser();
            bankApiUser.setApiUserId(bankAccess.getBankLogin());
            bankApiUser.setBankApi(BankApi.XS2A);
            bankApiUser.setProperties(new HashMap());
            bankApiUser.getProperties().put("allAccountsConsentId", this.createConsent(bankingUrl, bankAccess, pin, consents).getConsentId());
            return bankApiUser;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUser(String bankingUrl, BankApiUser bankApiUser) {
    }

    public ScaMethodsResponse authenticatePsu(String bankingUrl, AuthenticatePsuRequest authenticatePsuRequest) {
        return null;
    }

    public LoadAccountInformationResponse loadBankAccounts(String bankingUrl, LoadAccountInformationRequest loadAccountInformationRequest) {
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        String consentId = (String)loadAccountInformationRequest.getBankApiUser().getProperties().get("allAccountsConsentId");
        try {
            AccountList accountList = ais.getAccountList(UUID.randomUUID(), consentId, Boolean.valueOf(false), null, null, null, null, "127.0.0.1", null, null, null, null, null, null, null, null);
            return LoadAccountInformationResponse.builder().bankAccounts(accountList.getAccounts().stream().map(XS2AMapping::toBankAccount).collect(Collectors.toList())).build();
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeBankAccount(String bankingUrl, BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public LoadBookingsResponse loadBookings(String bankingUrl, LoadBookingsRequest loadBookingsRequest) {
        String consentId = (String)Optional.ofNullable(loadBookingsRequest.getBankApiUser().getProperties().get("consentId-" + loadBookingsRequest.getBankAccount().getIban())).orElseThrow(() -> new MissingConsentException("missing consent for transactions request"));
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        String resourceId = (String)loadBookingsRequest.getBankAccount().getExternalIdMap().get(BankApi.XS2A);
        try {
            TransactionsResponse200Json transactionList = ais.getTransactionList(resourceId, "booked", UUID.randomUUID(), consentId, null, null, null, null, null, null, null, null, null, "127.0.0.1", null, null, null, null, null, null, null, null);
            return LoadBookingsResponse.builder().bookings(XS2AMapping.toBookings(transactionList)).build();
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public List<BankAccount> loadBalances(String bankingUrl, LoadBalanceRequest loadBalanceRequest) {
        return null;
    }

    public boolean bankSupported(String bankCode) {
        return true;
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public ScaMethodsResponse initiatePayment(String bankingUrl, TransactionRequest paymentRequest) {
        return null;
    }

    public Object requestAuthorizationCode(String bankingUrl, TransactionRequest paymentRequest) {
        return null;
    }

    public String submitAuthorizationCode(SubmitAuthorizationCodeRequest submitPaymentRequest) {
        return null;
    }

    public boolean accountInformationConsentRequired(BankApiUser bankApiUser, String accountReference) {
        return !Optional.ofNullable(bankApiUser.getProperties().get("consentId-" + accountReference)).isPresent();
    }

    public void createAccountInformationConsent(String bankingUrl, CreateConsentRequest startScaRequest) {
        String newConsent = this.createDedicatedAccountConsent(bankingUrl, startScaRequest, startScaRequest.getBankAccess());
        startScaRequest.getBankApiUser().getProperties().put("consentId-" + startScaRequest.getIban(), newConsent);
    }

    private String createDedicatedAccountConsent(String bankingUrl, CreateConsentRequest startScaRequest, BankAccess bankAccess) {
        Consents consents = new Consents();
        consents.setValidUntil(LocalDate.now().plusYears(1L));
        consents.setFrequencyPerDay(Integer.valueOf(100));
        AccountReference accountReferenceIban = new AccountReference();
        accountReferenceIban.setIban(startScaRequest.getIban());
        accountReferenceIban.setCurrency("EUR");
        List<AccountReference> accounts = Arrays.asList(accountReferenceIban);
        AccountAccess accountAccess = new AccountAccess();
        accountAccess.setTransactions(accounts);
        accountAccess.setAccounts(accounts);
        accountAccess.setBalances(accounts);
        consents.setAccess(accountAccess);
        consents.setRecurringIndicator(Boolean.valueOf(true));
        try {
            return this.createConsent(bankingUrl, bankAccess, startScaRequest.getPin(), consents).getConsentId();
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    private ConsentsResponse201 createConsent(String bankingUrl, BankAccess bankAccess, String pin, Consents consents) throws ApiException {
        UUID session = UUID.randomUUID();
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        ConsentsResponse201 consent = ais.createConsent(session, consents, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, "false", null, null, null, "127.0.0.1", null, null, null, null, null, null, null, null, null);
        StartScaprocessResponse startScaprocessResponse = ais.startConsentAuthorisation(consent.getConsentId(), session, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, null, null, null, null, null, null, null, null, null, null);
        String authorisationLink = startScaprocessResponse.getLinks().get("startAuthorisationWithPsuAuthentication").toString();
        String authorizationId = StringUtils.substringAfterLast((String)authorisationLink, (String)"/");
        UpdatePsuAuthentication updatePsuAuthentication = new UpdatePsuAuthentication();
        updatePsuAuthentication.psuData(new PsuData().password(pin));
        Map updatePsuResponse = (Map)ais.updateConsentsPsuData(consent.getConsentId(), authorizationId, session, (Object)updatePsuAuthentication, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, null, null, null, null, null, null, null, null, null, null);
        List scaMethods = (List)updatePsuResponse.get("scaMethods");
        String otp = (String)scaMethods.stream().map(x -> x.get("authenticationMethodId")).filter(x -> "901".equals(x)).findFirst().get();
        SelectPsuAuthenticationMethod selectPsuAuthenticationMethod = new SelectPsuAuthenticationMethod();
        selectPsuAuthenticationMethod.setAuthenticationMethodId(otp);
        updatePsuResponse = (Map)ais.updateConsentsPsuData(consent.getConsentId(), authorizationId, session, (Object)selectPsuAuthenticationMethod, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, "127.0.0.1", null, null, null, null, null, null, null, null, null);
        TransactionAuthorisation transactionAuthorisation = new TransactionAuthorisation();
        transactionAuthorisation.setScaAuthenticationData("dontcare");
        updatePsuResponse = (Map)ais.updateConsentsPsuData(consent.getConsentId(), authorizationId, session, (Object)transactionAuthorisation, null, null, null, bankAccess.getBankLogin(), null, bankAccess.getBankLogin2(), null, "127.0.0.1", null, null, null, null, null, null, null, null, null);
        return consent;
    }

    private ApiClient createApiClient(String bankingUrl) {
        ApiClient apiClient = new ApiClient();
        OkHttpClient client = new OkHttpClient();
        client.interceptors().add(new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
        client.setReadTimeout(600L, TimeUnit.SECONDS);
        apiClient.setHttpClient(client);
        Optional.ofNullable(bankingUrl).ifPresent(url -> apiClient.setBasePath(url));
        return apiClient;
    }
}

