/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.xs2a.pis;

import de.adorsys.multibanking.xs2a.error.XS2AClientException;
import de.adorsys.multibanking.xs2a.pis.PainPaymentInitiationBodyBuilder;
import de.adorsys.multibanking.xs2a.pis.PaymentInitiationBodyBuilder;
import de.adorsys.multibanking.xs2a.pis.PaymentInitiationBuilderStrategy;
import de.adorsys.multibanking.xs2a.pis.PaymentProductType;
import de.adorsys.multibanking.xs2a.pis.PaymentServiceType;
import de.adorsys.multibanking.xs2a.pis.sepa.SepaBulkPaymentInitiationBodyBuilder;
import de.adorsys.multibanking.xs2a.pis.sepa.SepaPeriodicPaymentInitiationBodyBuilder;
import de.adorsys.multibanking.xs2a.pis.sepa.SepaSinglePaymentInitiationBodyBuilder;
import java.util.HashMap;
import java.util.Map;

public class PaymentInitiationBuilderStrategyImpl
implements PaymentInitiationBuilderStrategy {
    private static final String BUILDER_NOT_FOUND_ERROR_MESSAGE = "Can't find payment initiation builder for product %s and service %s";
    private Map<String, PaymentInitiationBodyBuilder> builders;
    private PaymentInitiationBodyBuilder rawPaymentBuilder = new PainPaymentInitiationBodyBuilder();

    public PaymentInitiationBuilderStrategyImpl() {
        this.builders = new HashMap<String, PaymentInitiationBodyBuilder>(3);
        this.builders.put(this.buildKey(PaymentProductType.SEPA, PaymentServiceType.SINGLE), new SepaSinglePaymentInitiationBodyBuilder());
        this.builders.put(this.buildKey(PaymentProductType.SEPA, PaymentServiceType.BULK), new SepaBulkPaymentInitiationBodyBuilder());
        this.builders.put(this.buildKey(PaymentProductType.SEPA, PaymentServiceType.PERIODIC), new SepaPeriodicPaymentInitiationBodyBuilder());
    }

    private String buildKey(PaymentProductType productType, PaymentServiceType serviceType) {
        return productType.getType() + serviceType.getType();
    }

    @Override
    public PaymentInitiationBodyBuilder resolve(PaymentProductType product, PaymentServiceType service) {
        if (product.isRaw()) {
            return this.rawPaymentBuilder;
        }
        String key = this.buildKey(product, service);
        if (!this.builders.containsKey(key)) {
            throw new XS2AClientException(String.format(BUILDER_NOT_FOUND_ERROR_MESSAGE, new Object[]{product, service}));
        }
        return this.builders.get(key);
    }
}

