/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a;

import de.adorsys.psd2.ApiClient;
import de.adorsys.psd2.ApiException;
import de.adorsys.psd2.api.AccountInformationServiceAisApi;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.AccountReferenceIban;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.model.ConsentsResponse201;
import de.adorsys.psd2.model.PsuData;
import de.adorsys.psd2.model.StartScaprocessResponse;
import de.adorsys.psd2.model.UpdatePsuAuthentication;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.LoadAccountInformationRequest;
import domain.LoadAccountInformationResponse;
import domain.LoadBookingsRequest;
import domain.LoadBookingsResponse;
import domain.Payment;
import domain.StandingOrder;
import java.time.LocalDate;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import spi.OnlineBankingService;

public class XS2ABanking
implements OnlineBankingService {
    public BankApi bankApi() {
        return BankApi.XS2A;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(String uid) {
        return null;
    }

    public void removeUser(BankApiUser bankApiUser) {
    }

    public LoadAccountInformationResponse loadBankAccounts(LoadAccountInformationRequest loadAccountInformationRequest) {
        AccountReferenceIban accountReferenceIban = new AccountReferenceIban().iban("DE81250400903312345678").currency("EUR");
        Consents consents = new Consents().access(new AccountAccess().availableAccounts(AccountAccess.AvailableAccountsEnum.ALLACCOUNTS)).frequencyPerDay(Integer.valueOf(Integer.MAX_VALUE)).validUntil(LocalDate.now().plusYears(1000L)).recurringIndicator(Boolean.valueOf(true));
        UUID requestId = UUID.randomUUID();
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath("http://localhost:8082");
        AccountInformationServiceAisApi service = new AccountInformationServiceAisApi(apiClient);
        try {
            ConsentsResponse201 consent = service.createConsent(requestId, consents, null, null, null, loadAccountInformationRequest.getBankAccess().getBankLogin(), null, null, null, Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, null, null, null);
            StartScaprocessResponse startScaprocessResponse = service.startConsentAuthorisation(consent.getConsentId(), requestId, null, null, null, loadAccountInformationRequest.getBankAccess().getBankLogin(), null, null, null, null, null, null, null, null, null, null, null, null, null);
            String authorisationLink = startScaprocessResponse.getLinks().get("startAuthorisationWithPsuAuthentication").toString();
            String authorizationId = StringUtils.substringAfterLast((String)authorisationLink, (String)"/");
            UpdatePsuAuthentication updatePsuAuthentication = new UpdatePsuAuthentication();
            updatePsuAuthentication.psuData(new PsuData().password(loadAccountInformationRequest.getPin()));
            Object o = service.updateConsentsPsuData(consent.getConsentId(), authorizationId, requestId, (Object)updatePsuAuthentication, null, null, null, loadAccountInformationRequest.getBankAccess().getBankLogin(), null, null, null, null, null, null, null, null, null, null, null, null, null);
            service.getAccountList(requestId, consent.getConsentId(), Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void removeBankAccount(BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public LoadBookingsResponse loadBookings(LoadBookingsRequest loadBookingsRequest) {
        return null;
    }

    public boolean bankSupported(String bankCode) {
        return true;
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public void createPayment(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, String pin, Payment payment) {
    }

    public void submitPayment(Payment payment, String pin, String tan) {
    }

    public void createStandingOrder(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, String pin, StandingOrder standingOrder) {
    }

    public void submitStandingOrder(StandingOrder standingOrder, String pin, String tan) {
    }
}

