/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.logging.HttpLoggingInterceptor;
import de.adorsys.psd2.ApiClient;
import de.adorsys.psd2.ApiException;
import de.adorsys.psd2.api.AccountInformationServiceAisApi;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.AccountList;
import de.adorsys.psd2.model.AccountReferenceIban;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.model.ConsentsResponse201;
import de.adorsys.psd2.model.PsuData;
import de.adorsys.psd2.model.SelectPsuAuthenticationMethod;
import de.adorsys.psd2.model.StartScaprocessResponse;
import de.adorsys.psd2.model.TransactionAuthorisation;
import de.adorsys.psd2.model.TransactionsResponse200Json;
import de.adorsys.psd2.model.UpdatePsuAuthentication;
import de.adorsys.xs2a.MissingConsentException;
import de.adorsys.xs2a.XS2AMapping;
import domain.AbstractPayment;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.CreateConsentRequest;
import domain.LoadAccountInformationRequest;
import domain.LoadAccountInformationResponse;
import domain.LoadBookingsRequest;
import domain.LoadBookingsResponse;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import spi.OnlineBankingService;

public class XS2ABanking
implements OnlineBankingService {
    public BankApi bankApi() {
        return BankApi.XS2A;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return true;
    }

    public BankApiUser registerUser(Optional<String> bankingUrl, BankAccess bankAccess, String pin) {
        String psuId = String.format("%s;%s;%s", bankAccess.getBankLogin(), bankAccess.getBankLogin2(), bankAccess.getBankCode());
        AccountAccess accountAccess = new AccountAccess();
        accountAccess.setAllPsd2(AccountAccess.AllPsd2Enum.ALLACCOUNTS);
        Consents consents = new Consents();
        consents.setValidUntil(LocalDate.now().plusDays(30L));
        consents.setFrequencyPerDay(Integer.valueOf(100));
        consents.setAccess(accountAccess);
        consents.setRecurringIndicator(Boolean.valueOf(true));
        try {
            BankApiUser bankApiUser = new BankApiUser();
            bankApiUser.setApiUserId(bankAccess.getBankLogin());
            bankApiUser.setBankApi(BankApi.XS2A);
            bankApiUser.setProperties(new HashMap());
            bankApiUser.getProperties().put("consentId", this.createConsent(bankingUrl, psuId, pin, consents).getConsentId());
            return bankApiUser;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUser(Optional<String> bankingUrl, BankApiUser bankApiUser) {
    }

    public LoadAccountInformationResponse loadBankAccounts(Optional<String> bankingUrl, LoadAccountInformationRequest loadAccountInformationRequest) {
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        String consentId = (String)loadAccountInformationRequest.getBankApiUser().getProperties().get("consentId");
        try {
            AccountList accountList = ais.getAccountList(UUID.randomUUID(), consentId, Boolean.valueOf(false), null, null, null, null, (Object)"127.0.0.1", null, null, null, null, null, null, null, null);
            return LoadAccountInformationResponse.builder().bankAccounts(accountList.getAccounts().stream().map(XS2AMapping::toBankAccount).collect(Collectors.toList())).build();
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeBankAccount(Optional<String> bankingUrl, BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public LoadBookingsResponse loadBookings(Optional<String> bankingUrl, LoadBookingsRequest loadBookingsRequest) {
        String consentId = (String)Optional.ofNullable(loadBookingsRequest.getBankApiUser().getProperties().get("consentId-" + loadBookingsRequest.getBankAccount().getIban())).orElseThrow(() -> new MissingConsentException("missing consent for transactions request"));
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        try {
            TransactionsResponse200Json transactionList = ais.getTransactionList(loadBookingsRequest.getBankAccount().getIban(), "booked", UUID.randomUUID(), consentId, null, null, null, null, null, null, null, null, null, (Object)"127.0.0.1", null, null, null, null, null, null, null, null);
            return LoadBookingsResponse.builder().bookings(XS2AMapping.toBookings(transactionList)).build();
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean bankSupported(String bankCode) {
        return true;
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public Object createPayment(Optional<String> bankingUrl, BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, String pin, AbstractPayment payment) {
        return null;
    }

    public Object deletePayment(Optional<String> bankingUrl, BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, String pin, AbstractPayment payment) {
        return null;
    }

    public String submitPayment(Optional<String> bankingUrl, AbstractPayment payment, Object tanSubmit, String pin, String tan) {
        return null;
    }

    public String submitDelete(Optional<String> bankingUrl, AbstractPayment payment, Object tanSubmit, String pin, String tan) {
        return null;
    }

    public boolean accountInformationConsentRequired(BankApiUser bankApiUser, String accountReference) {
        return !Optional.ofNullable(bankApiUser.getProperties().get("consentId-" + accountReference)).isPresent();
    }

    public void createAccountInformationConsent(Optional<String> bankingUrl, CreateConsentRequest startScaRequest) {
        String psuId = String.format("%s;%s;%s", startScaRequest.getBankAccess().getBankLogin(), startScaRequest.getBankAccess().getBankLogin2(), startScaRequest.getBankAccess().getBankCode());
        String newConsent = this.createAccountConsent(bankingUrl, startScaRequest, psuId);
        startScaRequest.getBankApiUser().getProperties().put("consentId-" + startScaRequest.getIban(), newConsent);
    }

    private String createAccountConsent(Optional<String> bankingUrl, CreateConsentRequest startScaRequest, String psuId) {
        Consents consents = new Consents();
        consents.setValidUntil(LocalDate.now().plusDays(30L));
        consents.setFrequencyPerDay(Integer.valueOf(100));
        AccountAccess accountAccess = new AccountAccess();
        List<Object> accounts = Arrays.asList(new AccountReferenceIban().currency("EUR").iban(startScaRequest.getIban()));
        accountAccess.setTransactions(accounts);
        accountAccess.setAccounts(accounts);
        accountAccess.setBalances(accounts);
        consents.setAccess(accountAccess);
        consents.setRecurringIndicator(Boolean.valueOf(true));
        try {
            return this.createConsent(bankingUrl, psuId, startScaRequest.getPin(), consents).getConsentId();
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    private ConsentsResponse201 createConsent(Optional<String> bankingUrl, String psuId, String pin, Consents consents) throws ApiException {
        UUID session = UUID.randomUUID();
        AccountInformationServiceAisApi ais = new AccountInformationServiceAisApi(this.createApiClient(bankingUrl));
        ConsentsResponse201 consent = ais.createConsent(session, consents, null, null, null, psuId, null, null, null, Boolean.valueOf(false), null, null, null, "127.0.0.1", null, null, null, null, null, null, null, null, null);
        StartScaprocessResponse startScaprocessResponse = ais.startConsentAuthorisation(consent.getConsentId(), session, null, null, null, psuId, null, null, null, null, null, null, null, null, null, null, null, null, null);
        String authorisationLink = startScaprocessResponse.getLinks().get("startAuthorisationWithPsuAuthentication").toString();
        String authorizationId = StringUtils.substringAfterLast((String)authorisationLink, (String)"/");
        UpdatePsuAuthentication updatePsuAuthentication = new UpdatePsuAuthentication();
        updatePsuAuthentication.psuData(new PsuData().password(pin));
        Map updatePsuResponse = (Map)ais.updateConsentsPsuData(consent.getConsentId(), authorizationId, session, (Object)updatePsuAuthentication, null, null, null, psuId, null, null, null, null, null, null, null, null, null, null, null, null, null);
        List scaMethods = (List)updatePsuResponse.get("scaMethods");
        String otp = (String)scaMethods.stream().map(x -> x.get("authenticationMethodId")).filter(x -> "SMS_OTP".equals(x)).findFirst().get();
        SelectPsuAuthenticationMethod selectPsuAuthenticationMethod = new SelectPsuAuthenticationMethod();
        selectPsuAuthenticationMethod.setAuthenticationMethodId(otp);
        updatePsuResponse = (Map)ais.updateConsentsPsuData(consent.getConsentId(), authorizationId, session, (Object)selectPsuAuthenticationMethod, null, null, null, psuId, null, null, null, "127.0.0.1", null, null, null, null, null, null, null, null, null);
        TransactionAuthorisation transactionAuthorisation = new TransactionAuthorisation();
        transactionAuthorisation.setScaAuthenticationData("dontcare");
        updatePsuResponse = (Map)ais.updateConsentsPsuData(consent.getConsentId(), authorizationId, session, (Object)transactionAuthorisation, null, null, null, psuId, null, null, null, "127.0.0.1", null, null, null, null, null, null, null, null, null);
        return consent;
    }

    private ApiClient createApiClient(Optional<String> bankingUrl) {
        ApiClient apiClient = new ApiClient();
        OkHttpClient client = new OkHttpClient();
        client.interceptors().add(new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
        client.setReadTimeout(600L, TimeUnit.SECONDS);
        apiClient.setHttpClient(client);
        bankingUrl.ifPresent(url -> apiClient.setBasePath(url));
        return apiClient;
    }
}

