/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.xs2a;

import de.adorsys.psd2.ApiClient;
import de.adorsys.psd2.ApiException;
import de.adorsys.psd2.api.AccountInformationServiceAisApi;
import de.adorsys.psd2.model.AccountAccess;
import de.adorsys.psd2.model.AccountReferenceIban;
import de.adorsys.psd2.model.Consents;
import de.adorsys.psd2.model.ConsentsResponse201;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.LoadBookingsResponse;
import domain.Payment;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import spi.OnlineBankingService;

public class XS2ABanking
implements OnlineBankingService {
    public BankApi bankApi() {
        return BankApi.XS2A;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return true;
    }

    public BankApiUser registerUser(String uid, String bankCode) {
        AccountReferenceIban accountReferenceIban = new AccountReferenceIban().iban(bankCode).currency("EUR");
        Consents consents = new Consents().access(new AccountAccess().addAccountsItem((Object)accountReferenceIban).addBalancesItem((Object)accountReferenceIban).addTransactionsItem((Object)accountReferenceIban)).frequencyPerDay(Integer.valueOf(Integer.MAX_VALUE)).validUntil(LocalDate.now().plusYears(1000L)).recurringIndicator(Boolean.valueOf(true));
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath("http://localhost:8081");
        AccountInformationServiceAisApi service = new AccountInformationServiceAisApi(apiClient);
        try {
            ConsentsResponse201 consent = service.createConsent(UUID.randomUUID(), consents, null, null, null, uid, null, null, null, Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, null, null, null);
            BankApiUser bankApiUser = new BankApiUser();
            bankApiUser.setApiUserId(uid);
            bankApiUser.setBankApi(BankApi.XS2A);
            bankApiUser.setProperties(new HashMap());
            bankApiUser.getProperties().put("consentId", consent.getConsentId());
            return bankApiUser;
        }
        catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUser(BankApiUser bankApiUser) {
    }

    public List<BankAccount> loadBankAccounts(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, String pin, boolean storePin) {
        return null;
    }

    public void removeBankAccount(BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public LoadBookingsResponse loadBookings(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, BankAccount bankAccount, String pin) {
        return null;
    }

    public boolean bankSupported(String bankCode) {
        return true;
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public void createPayment(BankApiUser bankApiUser, BankAccess bankAccess, String bankCode, String pin, Payment payment) {
    }

    public void submitPayment(Payment payment, String pin, String tan) {
    }
}

