/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mock.loader;

import de.adorsys.multibanking.mock.domain.BookingCategoryData;
import de.adorsys.multibanking.mock.service.XLSBookingService;
import de.adorsys.multibanking.mock.utils.CellUtils;
import domain.BankAccount;
import domain.BankApi;
import domain.Booking;
import domain.BookingCategory;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.poi.ss.usermodel.Row;

public class BookingLoader {
    private XLSBookingService bookingService;

    public BookingLoader(XLSBookingService bookingService) {
        this.bookingService = bookingService;
    }

    public void update(Row row) {
        String bankLogin = CellUtils.stringCell(row, 0, false);
        String iban = CellUtils.stringCell(row, 1, false);
        Booking booking = new Booking();
        booking.setBankApi(BankApi.MOCK);
        booking.setExternalId(UUID.randomUUID().toString());
        booking.setAmount(CellUtils.bigDecimalCell(row, 2, false));
        booking.setBalance(CellUtils.bigDecimalCell(row, 3, true));
        booking.setOrigValue(CellUtils.bigDecimalCell(row, 4, true));
        booking.setChargeValue(CellUtils.bigDecimalCell(row, 5, true));
        booking.setBookingDate(CellUtils.localDate(row, 6, false));
        booking.setValutaDate(CellUtils.localDate(row, 7, false));
        booking.setTransactionCode(CellUtils.stringFromNumCell(row, 8, true));
        booking.setReversal(CellUtils.booleanCell(row, 9, true).booleanValue());
        booking.setStandingOrder(CellUtils.booleanCell(row, 10, true).booleanValue());
        booking.setAdditional(CellUtils.stringCell(row, 11, true));
        booking.setUsage(CellUtils.stringCell(row, 12, false));
        booking.setText(CellUtils.stringCell(row, 13, true));
        booking.setSepa(CellUtils.booleanCell(row, 14, true).booleanValue());
        booking.setMandateReference(CellUtils.stringCell(row, 15, true));
        booking.setInstRef(CellUtils.stringCell(row, 16, true));
        booking.setCreditorId(CellUtils.stringCell(row, 17, true));
        booking.setCustomerRef(CellUtils.stringCell(row, 18, true));
        BankAccount bankAccount = new BankAccount();
        bankAccount.setOwner(CellUtils.stringCell(row, 19, true));
        bankAccount.setName(bankAccount.getOwner());
        bankAccount.setIban(CellUtils.stringCell(row, 20, false));
        bankAccount.setBic(CellUtils.stringCell(row, 21, true));
        bankAccount.setBankName(CellUtils.stringCell(row, 22, true));
        booking.setOtherAccount(bankAccount);
        this.bookingService.addBooking(bankLogin, iban, booking);
    }

    public static void setContract(List<Booking> bookings, BookingCategoryData contracts) {
        if (contracts == null) {
            return;
        }
        List<BookingCategory> incomeCategory = contracts.getInsuranceCategory();
        int i = 0;
        for (BookingCategory it : incomeCategory) {
            double amount = new Random().nextDouble() * 100.0;
            for (int j = 0; j < 4 && i < bookings.size(); ++i, ++j) {
                bookings.get(i).setBookingDate(LocalDate.now().minusMonths(j));
                bookings.get(i).setValutaDate(LocalDate.now().minusMonths(j));
                bookings.get(i).setBookingCategory(it);
                bookings.get(i).setAmount(BigDecimal.valueOf(amount));
                bookings.get(i).setUsage(it.getSpecification());
            }
        }
    }
}

