/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mock.domain;

import de.adorsys.multibanking.mock.domain.BankAccessData;
import de.adorsys.multibanking.mock.service.XLSBankAccessService;
import de.adorsys.multibanking.mock.service.XLSBankAccountService;
import de.adorsys.multibanking.mock.service.XLSBookingService;
import de.adorsys.multibanking.mock.service.XLSStandingOrderService;
import domain.BankAccess;
import domain.BankAccount;
import domain.Booking;
import domain.StandingOrder;
import exception.ResourceNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MockAccount
implements XLSBankAccessService,
XLSBankAccountService,
XLSBookingService,
XLSStandingOrderService {
    private final Map<String, BankAccessData> bankAccessMapByBankLogin = new HashMap<String, BankAccessData>();

    public void addBankAccess(BankAccessData bankAccess) {
        this.bankAccessMapByBankLogin.put(bankAccess.getBankAccess().getBankLogin(), bankAccess);
    }

    public Optional<BankAccessData> access(String bankLogin) {
        return Optional.ofNullable(this.bankAccessMapByBankLogin.get(bankLogin));
    }

    public BankAccessData accessOrException(String bankLogin) {
        return this.access(bankLogin).orElseThrow(() -> this.notFound(bankLogin));
    }

    private ResourceNotFoundException notFound(String bankLogin) {
        return new ResourceNotFoundException(String.format("BankLogin with id %s not found", bankLogin));
    }

    @Override
    public void addStandingOrders(String bankLogin, String iban, StandingOrder standingOrder) {
        this.accessOrException(bankLogin).accountDataOrException(iban).addStandingOrders(iban, standingOrder);
    }

    @Override
    public void addBooking(String bankLogin, String iban, Booking booking) {
        this.accessOrException(bankLogin).accountDataOrException(iban).addBooking(booking);
    }

    @Override
    public void addBankAccount(String bankLogin, BankAccount bankAccount) {
        bankAccount.setIban(bankAccount.getIban());
        this.accessOrException(bankLogin).addBankAccount(bankAccount);
    }

    @Override
    public boolean hasBankAccessForBankCode(String bankLogin, String bankCode) {
        if (this.access(bankLogin).isPresent()) {
            return this.accessOrException(bankLogin).bankCode(bankCode).isPresent();
        }
        return false;
    }

    @Override
    public void addBankAccess(String bankLogin, String pin, BankAccess bankAccess) {
        this.addBankAccess(new BankAccessData(bankAccess, pin));
    }

    public List<BankAccount> loadBankAccounts(BankAccess bankAccess, String bankCode, String pin) {
        BankAccessData accessData = this.accessOrException(bankAccess.getBankLogin());
        accessData.checkPin(pin);
        return accessData.loadBankAccounts(bankCode);
    }
}

