/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mock.utils;

import domain.BankAccount;
import exception.InvalidIbanException;
import org.apache.commons.lang3.StringUtils;
import org.iban4j.IbanUtil;

public class IbanUtils {
    public static void extractDetailFromIban(BankAccount bankAccount) {
        String iban = bankAccount.getIban();
        if (StringUtils.isBlank((CharSequence)iban)) {
            return;
        }
        try {
            bankAccount.setAccountNumber(IbanUtil.getAccountNumber((String)iban));
            bankAccount.setCountry(IbanUtil.getCountryCode((String)iban));
            bankAccount.setBlz(IbanUtil.getBankCode((String)iban));
        }
        catch (Exception e) {
            throw new InvalidIbanException(String.format("The IBAN: %s is not well formatted  eg:DE81100000004076397393 ", iban));
        }
    }
}

