/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mock.domain;

import domain.BankAccount;
import domain.Booking;
import domain.StandingOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BankAccountData {
    private final BankAccount bankAccount;
    private final List<Booking> bookings = new ArrayList<Booking>();
    private final Map<String, StandingOrder> standingOrderMap = new HashMap<String, StandingOrder>();

    public BankAccountData(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public void addStandingOrders(String iban, StandingOrder standingOrder) {
        this.standingOrderMap.put(standingOrder.getOrderId(), standingOrder);
    }

    public void addBooking(Booking booking) {
        this.bookings.add(booking);
    }

    public Map<String, StandingOrder> standingOrders() {
        return this.standingOrderMap;
    }

    public List<Booking> bookings() {
        return this.bookings;
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }
}

