/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mock.loader;

import de.adorsys.multibanking.mock.exception.DuplicatedResourceException;
import de.adorsys.multibanking.mock.service.XLSBankAccessService;
import de.adorsys.multibanking.mock.utils.CellUtils;
import domain.BankAccess;
import org.apache.poi.ss.usermodel.Row;

public class BankAccesLoader {
    private XLSBankAccessService bankAccesService;

    public BankAccesLoader(XLSBankAccessService bankAccesService) {
        this.bankAccesService = bankAccesService;
    }

    public void update(Row row) {
        BankAccess bankAccess = new BankAccess();
        bankAccess.setBankCode(CellUtils.stringFromNumCell(row, 0, false));
        bankAccess.setBankLogin(CellUtils.stringCell(row, 1, false));
        String pin = CellUtils.stringFromNumCell(row, 3, false);
        bankAccess.setHbciPassportState(CellUtils.stringCell(row, 4, true));
        if (this.bankAccesService.hasBankAccessForBankCode(bankAccess.getBankLogin(), bankAccess.getBankCode())) {
            throw new DuplicatedResourceException("BankAccess with bank code already exist " + bankAccess.getBankCode());
        }
        this.bankAccesService.addBankAccess(bankAccess.getBankLogin(), pin, bankAccess);
    }
}

