/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mock.domain;

import de.adorsys.multibanking.mock.domain.BankAccountData;
import domain.BankAccess;
import domain.BankAccount;
import exception.InvalidPinException;
import exception.ResourceNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class BankAccessData {
    private final BankAccess bankAccess;
    private final String pin;
    private final Map<String, BankAccountData> bankAccountMap = new HashMap<String, BankAccountData>();

    public BankAccessData(BankAccess bankAccess, String pin) {
        this.bankAccess = bankAccess;
        this.pin = pin;
    }

    public BankAccess getBankAccess() {
        return this.bankAccess;
    }

    public String getPin() {
        return this.pin;
    }

    public void checkPin(String pin) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.pin, (CharSequence)pin)) {
            throw new InvalidPinException();
        }
    }

    public void addBankAccount(BankAccount bankAccount) {
        this.bankAccountMap.put(bankAccount.getIban(), new BankAccountData(bankAccount));
    }

    public Optional<BankAccountData> accountData(String iban) {
        return Optional.ofNullable(this.bankAccountMap.get(iban));
    }

    public BankAccountData accountDataOrException(String iban) {
        return this.accountData(iban).orElseThrow(() -> this.notFound(iban));
    }

    private ResourceNotFoundException notFound(String iban) {
        return new ResourceNotFoundException(String.format("BankAccount with iban %s for bank login %s not found", iban, this.bankAccess.getBankLogin()));
    }

    public Optional<BankAccountData> bankCode(String bankCode) {
        return this.bankAccountMap.values().stream().filter(b -> StringUtils.equalsIgnoreCase((CharSequence)bankCode, (CharSequence)b.getBankAccount().getBic())).findFirst();
    }

    public int countAccounts() {
        return this.bankAccountMap.size();
    }

    public List<BankAccount> loadBankAccounts(String bankCode) {
        return this.bankAccountMap.values().stream().map(BankAccountData::getBankAccount).collect(Collectors.toList());
    }
}

