/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mock.loader;

import de.adorsys.multibanking.mock.exception.InvalidRowException;
import de.adorsys.multibanking.mock.loader.BankAccesLoader;
import de.adorsys.multibanking.mock.loader.BankAccountLoader;
import de.adorsys.multibanking.mock.loader.BookingLoader;
import de.adorsys.multibanking.mock.loader.StandingOrderLoader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.util.IOUtils;

public class DataSheetLoader {
    private static final Logger LOG = Logger.getLogger(DataSheetLoader.class.getName());
    private BankAccesLoader bankAccesLoader;
    private BankAccountLoader bankAccountLoader;
    private BookingLoader bookingLoader;
    private StandingOrderLoader standingOrderLoader;

    public DataSheetLoader(BankAccesLoader bankAccesLoader, BankAccountLoader bankAccountLoader, BookingLoader bookingLoader, StandingOrderLoader standingOrderLoader) {
        this.bankAccesLoader = bankAccesLoader;
        this.bankAccountLoader = bankAccountLoader;
        this.bookingLoader = bookingLoader;
        this.standingOrderLoader = standingOrderLoader;
    }

    public void loadDataSheet(InputStream dataStream) {
        if (dataStream == null) {
            throw new IllegalArgumentException("dataStream can not be null");
        }
        try {
            HSSFWorkbook workbook = new HSSFWorkbook(dataStream);
            this.updateBankAccess(workbook);
            this.updateBankAccount(workbook);
            this.updateBooking(workbook);
            this.updateStandingOrder(workbook);
            IOUtils.closeQuietly((Closeable)dataStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)dataStream);
        }
    }

    public void updateBankAccess(HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheet("BankAccess");
        if (sheet == null) {
            return;
        }
        Iterator rowIterator = sheet.rowIterator();
        Row row1 = (Row)rowIterator.next();
        rowIterator.forEachRemaining(row -> {
            try {
                this.bankAccesLoader.update((Row)row);
            }
            catch (InvalidRowException i) {
                LOG.severe(i.getMessage());
            }
        });
    }

    public void updateBankAccount(HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheet("BankAccount");
        if (sheet == null) {
            return;
        }
        Iterator rowIterator = sheet.rowIterator();
        rowIterator.next();
        rowIterator.forEachRemaining(row -> {
            try {
                this.bankAccountLoader.update((Row)row);
            }
            catch (InvalidRowException i) {
                LOG.severe(i.getMessage());
            }
        });
    }

    public void updateBooking(HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheet("Booking");
        if (sheet == null) {
            return;
        }
        Iterator rowIterator = sheet.rowIterator();
        System.out.println("roo number " + sheet.getLastRowNum());
        rowIterator.next();
        rowIterator.forEachRemaining(row -> {
            try {
                this.bookingLoader.update((Row)row);
            }
            catch (InvalidRowException i) {
                LOG.severe(i.getMessage());
            }
        });
    }

    private void updateStandingOrder(HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheet("StandingOrder");
        if (sheet == null) {
            return;
        }
        Iterator rowIterator = sheet.rowIterator();
        rowIterator.next();
        rowIterator.forEachRemaining(row -> {
            try {
                this.standingOrderLoader.update((Row)row);
            }
            catch (InvalidRowException i) {
                LOG.severe(i.getMessage());
            }
        });
    }
}

