/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mock.utils;

import de.adorsys.multibanking.mock.exception.InvalidRowException;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class CellUtils {
    public static String stringCell(Row row, int index, boolean optional) {
        Cell cell = row.getCell(index);
        if (cell != null && StringUtils.isNotBlank((CharSequence)cell.getStringCellValue())) {
            return cell.getStringCellValue().trim();
        }
        return (String)CellUtils.nullOrException(index, optional);
    }

    public static BigDecimal bigDecimalCell(Row row, int index, boolean optional) {
        Cell cell = row.getCell(index);
        if (cell != null) {
            try {
                cell.setCellType(0);
                return new BigDecimal(cell.getNumericCellValue());
            }
            catch (Exception e) {
                try {
                    return new BigDecimal(cell.getStringCellValue());
                }
                catch (Exception e2) {
                    CellUtils.invalideException(LocalDate.class, index, optional, e2);
                }
            }
        }
        return (BigDecimal)CellUtils.nullOrException(index, optional);
    }

    public static LocalDate localDate(Row row, int index, boolean optional) {
        Cell cell = row.getCell(index);
        try {
            return LocalDate.parse(cell.getStringCellValue());
        }
        catch (Exception e) {
            CellUtils.invalideException(LocalDate.class, index, optional, e);
            return (LocalDate)CellUtils.nullOrException(index, optional);
        }
    }

    public static Boolean booleanCell(Row row, int index, boolean optional) {
        Cell cell = row.getCell(index);
        if (cell != null) {
            return cell.getBooleanCellValue();
        }
        return (Boolean)CellUtils.nullOrException(index, optional);
    }

    public static String stringFromNumCell(Row row, int index, boolean optional) {
        Cell cell = row.getCell(index);
        if (cell != null) {
            try {
                return cell.getStringCellValue();
            }
            catch (Exception e) {
                return String.format("%s", Double.valueOf(cell.getNumericCellValue()).intValue());
            }
        }
        return (String)CellUtils.nullOrException(index, optional);
    }

    private static <T> T nullOrException(int index, boolean optional) {
        if (optional) {
            return null;
        }
        throw new InvalidRowException(String.format("Row at %s null or empty: ", index));
    }

    private static <T> void invalideException(Class<T> klass, int index, boolean optional, Exception ex) {
        if (!optional) {
            throw new InvalidRowException(String.format("Row at %s can not be converted to type %s: ", index, klass.getName()), ex);
        }
    }
}

