/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mock.loader;

import de.adorsys.multibanking.mock.service.XLSStandingOrderService;
import de.adorsys.multibanking.mock.utils.CellUtils;
import de.adorsys.multibanking.mock.utils.IbanUtils;
import domain.BankAccount;
import domain.Cycle;
import domain.StandingOrder;
import org.apache.poi.ss.usermodel.Row;

public class StandingOrderLoader {
    private XLSStandingOrderService standingOrderService;

    public StandingOrderLoader(XLSStandingOrderService standingOrderService) {
        this.standingOrderService = standingOrderService;
    }

    public void update(Row row) {
        String bankLogin = CellUtils.stringCell(row, 0, false);
        String iban = CellUtils.stringCell(row, 1, false);
        StandingOrder standingOrder = new StandingOrder();
        standingOrder.setAmount(CellUtils.bigDecimalCell(row, 2, false));
        standingOrder.setCycle(Cycle.valueOf((String)CellUtils.stringCell(row, 3, false)));
        standingOrder.setExecutionDay(CellUtils.bigDecimalCell(row, 4, false).intValue());
        standingOrder.setFirstExecutionDate(CellUtils.localDate(row, 5, false));
        standingOrder.setLastExecutionDate(CellUtils.localDate(row, 6, true));
        standingOrder.setUsage(CellUtils.stringCell(row, 7, false));
        BankAccount bankAccount = new BankAccount();
        bankAccount.setOwner(CellUtils.stringCell(row, 8, true));
        bankAccount.setIban(CellUtils.stringCell(row, 9, true));
        bankAccount.setBic(CellUtils.stringCell(row, 10, true));
        bankAccount.setBankName(CellUtils.stringCell(row, 11, true));
        IbanUtils.extractDetailFromIban(bankAccount);
        standingOrder.setOtherAccount(bankAccount);
        standingOrder.setOrderId(this.orderId(standingOrder));
        this.standingOrderService.addStandingOrders(bankLogin, iban, standingOrder);
    }

    private String orderId(StandingOrder standingOrder) {
        String iban = standingOrder.getOtherAccount().getIban();
        return "" + standingOrder.getAmount() + standingOrder.getCycle() + standingOrder.getUsage() + iban;
    }
}

