/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mapper;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.Booking;
import de.adorsys.multibanking.domain.utils.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(imports={BigDecimal.class, HBCIUtils.class})
public interface AccountStatementMapper {
    default public BalancesReport createBalancesReport(GVRSaldoReq gvSaldoReq, String accountNumber) {
        return gvSaldoReq.getEntries().stream().filter(info -> StringUtils.stripStart((String)info.konto.number, (String)"0").equals(StringUtils.stripStart((String)accountNumber, (String)"0"))).findAny().map(this::toBalancesReport).orElse(null);
    }

    @Mappings(value={@Mapping(target="readyBalance", source="ready"), @Mapping(target="availableBalance", source="available"), @Mapping(target="creditBalance", source="kredit"), @Mapping(target="unreadyBalance", source="unready"), @Mapping(target="usedBalance", source="used")})
    public BalancesReport toBalancesReport(GVRSaldoReq.Info var1);

    @Mappings(value={@Mapping(target="currency", source="curr"), @Mapping(target="amount", expression="java(new BigDecimal(HBCIUtils.bigDecimal2String(value.getBigDecimalValue())))"), @Mapping(target="date", ignore=true)})
    public Balance toBalance(Value var1);

    @Mappings(value={@Mapping(target="currency", source="value.curr"), @Mapping(target="amount", expression="java(new BigDecimal(HBCIUtils.bigDecimal2String(saldo.value.getBigDecimalValue())))"), @Mapping(target="date", source="timestamp")})
    public Balance toBalance(Saldo var1);

    default public List<Booking> createBookings(GVRKUms gvrkUms) {
        ArrayList<Booking> bookings = new ArrayList<Booking>();
        List lines = gvrkUms.getFlatData();
        for (GVRKUms.UmsLine line : lines) {
            Booking booking = this.toBooking(line);
            if (line != null && line.other != null) {
                booking.setOtherAccount(this.toBankAccount(line.other));
                String differentInitiator = Utils.extractDifferentInitiator((String)booking.getUsage());
                if (differentInitiator != null) {
                    booking.getOtherAccount().setOwner(booking.getOtherAccount().getOwner() + " " + differentInitiator);
                }
                if (StringUtils.isBlank((CharSequence)booking.getOtherAccount().getIban())) {
                    booking.getOtherAccount().setIban(Utils.extractIban((String)booking.getUsage()));
                }
            }
            bookings.add(0, booking);
        }
        return bookings;
    }

    @Mappings(value={@Mapping(target="accountNumber", source="number"), @Mapping(target="currency", source="curr"), @Mapping(target="name", source="type"), @Mapping(target="owner", expression="java((konto.name + (konto.name2 != null ? konto.name2 : \"\")).trim())"), @Mapping(target="type", expression="java(de.adorsys.multibanking.domain.BankAccountType.fromHbciType(org.apache.commons.lang3.math.NumberUtils.toInt(konto.acctype)))"), @Mapping(target="balances", ignore=true), @Mapping(target="bankName", ignore=true), @Mapping(target="externalIdMap", ignore=true), @Mapping(target="syncStatus", ignore=true), @Mapping(target="lastSync", ignore=true)})
    public BankAccount toBankAccount(Konto var1);

    @Mappings(value={@Mapping(target="bankApi", constant="HBCI"), @Mapping(target="usage", expression="java( getUsage(line.usage.size() > 0 ? line.usage : splitEqually(line.additional, 27)))"), @Mapping(target="bookingDate", source="bdate"), @Mapping(target="valutaDate", source="valuta"), @Mapping(target="amount", expression="java(new BigDecimal(HBCIUtils.bigDecimal2String(line.value.getBigDecimalValue())))"), @Mapping(target="currency", source="value.curr"), @Mapping(target="reversal", source="storno"), @Mapping(target="transactionCode", source="purposecode"), @Mapping(target="balance", expression="java(new BigDecimal(HBCIUtils.bigDecimal2String(line.saldo.value.getBigDecimalValue())))"), @Mapping(target="externalId", expression="java(\"B-\" + line.valuta.getTime() + \"_\" + line.value.getLongValue() + \"_\" + line.saldo.value.getLongValue())"), @Mapping(target="origValue", expression="java(line.orig_value == null ? null : new BigDecimal(HBCIUtils.bigDecimal2String(line.orig_value.getBigDecimalValue())))"), @Mapping(target="chargeValue", expression="java(line.charge_value == null ? null : new BigDecimal(HBCIUtils.bigDecimal2String(line.charge_value.getBigDecimalValue())))"), @Mapping(target="creditorId", expression="java(de.adorsys.multibanking.domain.utils.Utils.extractCreditorId(booking.getUsage()))"), @Mapping(target="mandateReference", expression="java(de.adorsys.multibanking.domain.utils.Utils.extractMandateReference(booking.getUsage()))"), @Mapping(target="otherAccount", ignore=true), @Mapping(target="standingOrder", ignore=true), @Mapping(target="bookingCategory", ignore=true)})
    public Booking toBooking(GVRKUms.UmsLine var1);

    default public String getUsage(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        if (lines != null) {
            for (String line : lines) {
                if (line == null) continue;
                sb.append(StringUtils.chomp((String)line));
                sb.append(line.length() < 27 ? " " : "");
            }
        }
        return WordUtils.capitalizeFully((String)sb.toString().trim(), (char[])new char[]{' ', '/'});
    }

    default public List<String> splitEqually(String text, int size) {
        if (text == null || text.length() == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        for (int start = 0; start < text.length(); start += size) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
        }
        return ret;
    }
}

