/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mapper;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountType;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.Booking;
import de.adorsys.multibanking.domain.utils.Utils;
import de.adorsys.multibanking.mapper.AccountStatementMapper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.commons.lang3.math.NumberUtils;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;

public class AccountStatementMapperImpl
implements AccountStatementMapper {
    @Override
    public BalancesReport toBalancesReport(GVRSaldoReq.Info saldoInfo) {
        if (saldoInfo == null) {
            return null;
        }
        BalancesReport balancesReport = new BalancesReport();
        balancesReport.setReadyBalance(this.toBalance(saldoInfo.ready));
        balancesReport.setAvailableBalance(this.toBalance(saldoInfo.available));
        balancesReport.setCreditBalance(this.toBalance(saldoInfo.kredit));
        balancesReport.setUnreadyBalance(this.toBalance(saldoInfo.unready));
        balancesReport.setReservedBalance(this.toBalance(saldoInfo.reserved));
        balancesReport.setUsedBalance(this.toBalance(saldoInfo.used));
        return balancesReport;
    }

    @Override
    public Balance toBalance(Value value) {
        if (value == null) {
            return null;
        }
        Balance.BalanceBuilder balance = Balance.builder();
        balance.currency(value.getCurr());
        balance.amount(new BigDecimal(HBCIUtils.bigDecimal2String((BigDecimal)value.getBigDecimalValue())));
        return balance.build();
    }

    @Override
    public Balance toBalance(Saldo saldo) {
        if (saldo == null) {
            return null;
        }
        Balance.BalanceBuilder balance = Balance.builder();
        balance.currency(this.saldoValueCurr(saldo));
        if (saldo.timestamp != null) {
            balance.date(LocalDateTime.ofInstant(saldo.timestamp.toInstant(), ZoneOffset.UTC).toLocalDate());
        }
        balance.amount(new BigDecimal(HBCIUtils.bigDecimal2String((BigDecimal)saldo.value.getBigDecimalValue())));
        return balance.build();
    }

    @Override
    public BankAccount toBankAccount(Konto konto) {
        if (konto == null) {
            return null;
        }
        BankAccount bankAccount = new BankAccount();
        bankAccount.setAccountNumber(konto.number);
        bankAccount.setCurrency(konto.curr);
        bankAccount.setName(konto.type);
        bankAccount.setCountry(konto.country);
        bankAccount.setBlz(konto.blz);
        bankAccount.setBic(konto.bic);
        bankAccount.setIban(konto.iban);
        bankAccount.setOwner((konto.name + (konto.name2 != null ? konto.name2 : "")).trim());
        bankAccount.setType(BankAccountType.fromHbciType((Integer)NumberUtils.toInt((String)konto.acctype)));
        return bankAccount;
    }

    @Override
    public Booking toBooking(GVRKUms.UmsLine line) {
        if (line == null) {
            return null;
        }
        Booking booking = new Booking();
        if (line.bdate != null) {
            booking.setBookingDate(LocalDateTime.ofInstant(line.bdate.toInstant(), ZoneOffset.UTC).toLocalDate());
        }
        if (line.valuta != null) {
            booking.setValutaDate(LocalDateTime.ofInstant(line.valuta.toInstant(), ZoneOffset.UTC).toLocalDate());
        }
        booking.setCurrency(this.lineValueCurr(line));
        booking.setReversal(line.storno);
        booking.setTransactionCode(line.purposecode);
        booking.setCustomerRef(line.customerRef);
        booking.setInstRef(line.instRef);
        booking.setText(line.text);
        booking.setAdditional(line.additional);
        booking.setPrimanota(line.primanota);
        booking.setAddkey(line.addkey);
        booking.setSepa(line.sepa);
        booking.setCamt(line.camt);
        booking.setBankApi(BankApi.HBCI);
        booking.setUsage(this.getUsage(line.usage.size() > 0 ? line.usage : this.splitEqually(line.additional, 27)));
        booking.setAmount(new BigDecimal(HBCIUtils.bigDecimal2String((BigDecimal)line.value.getBigDecimalValue())));
        booking.setBalance(new BigDecimal(HBCIUtils.bigDecimal2String((BigDecimal)line.saldo.value.getBigDecimalValue())));
        booking.setExternalId("B-" + line.valuta.getTime() + "_" + line.value.getLongValue() + "_" + line.saldo.value.getLongValue());
        booking.setOrigValue(line.orig_value == null ? null : new BigDecimal(HBCIUtils.bigDecimal2String((BigDecimal)line.orig_value.getBigDecimalValue())));
        booking.setChargeValue(line.charge_value == null ? null : new BigDecimal(HBCIUtils.bigDecimal2String((BigDecimal)line.charge_value.getBigDecimalValue())));
        booking.setCreditorId(Utils.extractCreditorId((String)booking.getUsage()));
        booking.setMandateReference(Utils.extractMandateReference((String)booking.getUsage()));
        return booking;
    }

    private String saldoValueCurr(Saldo saldo) {
        if (saldo == null) {
            return null;
        }
        Value value = saldo.value;
        if (value == null) {
            return null;
        }
        String curr = value.getCurr();
        if (curr == null) {
            return null;
        }
        return curr;
    }

    private String lineValueCurr(GVRKUms.UmsLine umsLine) {
        if (umsLine == null) {
            return null;
        }
        Value value = umsLine.value;
        if (value == null) {
            return null;
        }
        String curr = value.getCurr();
        if (curr == null) {
            return null;
        }
        return curr;
    }
}

