package de.adorsys.multibanking.mapper;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.Balance.BalanceBuilder;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.Booking;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import javax.annotation.processing.Generated;
import org.kapott.hbci.GV_Result.GVRKUms.UmsLine;
import org.kapott.hbci.GV_Result.GVRSaldoReq.Info;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-08-06T12:56:51+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
public class AccountStatementMapperImpl implements AccountStatementMapper {

    @Override
    public BalancesReport toBalancesReport(Info saldoInfo) {
        if ( saldoInfo == null ) {
            return null;
        }

        BalancesReport balancesReport = new BalancesReport();

        balancesReport.setReadyBalance( toBalance( saldoInfo.ready ) );
        balancesReport.setAvailableBalance( toBalance( saldoInfo.available ) );
        balancesReport.setCreditBalance( toBalance( saldoInfo.kredit ) );
        balancesReport.setUnreadyBalance( toBalance( saldoInfo.unready ) );
        balancesReport.setUsedBalance( toBalance( saldoInfo.used ) );

        return balancesReport;
    }

    @Override
    public Balance toBalance(Value value) {
        if ( value == null ) {
            return null;
        }

        BalanceBuilder balance = Balance.builder();

        balance.currency( value.getCurr() );

        balance.amount( new BigDecimal(HBCIUtils.bigDecimal2String(value.getBigDecimalValue())) );

        return balance.build();
    }

    @Override
    public Balance toBalance(Saldo saldo) {
        if ( saldo == null ) {
            return null;
        }

        BalanceBuilder balance = Balance.builder();

        balance.currency( saldoValueCurr( saldo ) );
        if ( saldo.timestamp != null ) {
            balance.date( LocalDateTime.ofInstant( saldo.timestamp.toInstant(), ZoneOffset.UTC ).toLocalDate() );
        }

        balance.amount( new BigDecimal(HBCIUtils.bigDecimal2String(saldo.value.getBigDecimalValue())) );

        return balance.build();
    }

    @Override
    public BankAccount toBankAccount(Konto konto) {
        if ( konto == null ) {
            return null;
        }

        BankAccount bankAccount = new BankAccount();

        bankAccount.setAccountNumber( konto.number );
        bankAccount.setCurrency( konto.curr );
        bankAccount.setName( konto.type );
        bankAccount.setCountry( konto.country );
        bankAccount.setBlz( konto.blz );
        bankAccount.setBic( konto.bic );
        bankAccount.setIban( konto.iban );

        bankAccount.setOwner( (konto.name + (konto.name2 != null ? konto.name2 : "")).trim() );
        bankAccount.setType( de.adorsys.multibanking.domain.BankAccountType.fromHbciType(org.apache.commons.lang3.math.NumberUtils.toInt(konto.acctype)) );

        return bankAccount;
    }

    @Override
    public Booking toBooking(UmsLine line) {
        if ( line == null ) {
            return null;
        }

        Booking booking = new Booking();

        if ( line.bdate != null ) {
            booking.setBookingDate( LocalDateTime.ofInstant( line.bdate.toInstant(), ZoneOffset.UTC ).toLocalDate() );
        }
        if ( line.valuta != null ) {
            booking.setValutaDate( LocalDateTime.ofInstant( line.valuta.toInstant(), ZoneOffset.UTC ).toLocalDate() );
        }
        booking.setCurrency( lineValueCurr( line ) );
        booking.setReversal( line.storno );
        booking.setTransactionCode( line.purposecode );
        booking.setCustomerRef( line.customerRef );
        booking.setInstRef( line.instRef );
        booking.setText( line.text );
        booking.setAdditional( line.additional );
        booking.setPrimanota( line.primanota );
        booking.setAddkey( line.addkey );
        booking.setSepa( line.sepa );
        booking.setCamt( line.camt );

        booking.setBankApi( BankApi.HBCI );
        booking.setUsage( getUsage(line.usage.size() > 0 ? line.usage : splitEqually(line.additional, 27)) );
        booking.setAmount( new BigDecimal(HBCIUtils.bigDecimal2String(line.value.getBigDecimalValue())) );
        booking.setBalance( new BigDecimal(HBCIUtils.bigDecimal2String(line.saldo.value.getBigDecimalValue())) );
        booking.setExternalId( "B-" + line.valuta.getTime() + "_" + line.value.getLongValue() + "_" + line.saldo.value.getLongValue() );
        booking.setOrigValue( line.orig_value == null ? null : new BigDecimal(HBCIUtils.bigDecimal2String(line.orig_value.getBigDecimalValue())) );
        booking.setChargeValue( line.charge_value == null ? null : new BigDecimal(HBCIUtils.bigDecimal2String(line.charge_value.getBigDecimalValue())) );
        booking.setCreditorId( de.adorsys.multibanking.domain.utils.Utils.extractCreditorId(booking.getUsage()) );
        booking.setMandateReference( de.adorsys.multibanking.domain.utils.Utils.extractMandateReference(booking.getUsage()) );

        return booking;
    }

    private String saldoValueCurr(Saldo saldo) {
        if ( saldo == null ) {
            return null;
        }
        Value value = saldo.value;
        if ( value == null ) {
            return null;
        }
        String curr = value.getCurr();
        if ( curr == null ) {
            return null;
        }
        return curr;
    }

    private String lineValueCurr(UmsLine umsLine) {
        if ( umsLine == null ) {
            return null;
        }
        Value value = umsLine.value;
        if ( value == null ) {
            return null;
        }
        String curr = value.getCurr();
        if ( curr == null ) {
            return null;
        }
        return curr;
    }
}
