/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.mapper;

import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.Booking;
import de.adorsys.multibanking.domain.response.TransactionsResponse;
import de.adorsys.multibanking.mapper.AccountStatementMapper;
import de.adorsys.multibanking.mapper.AccountStatementMapperImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.sepa.SepaVersion;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.swift.Swift;

public class TransactionsParser {
    private static AccountStatementMapper accountStatementMapper = new AccountStatementMapperImpl();

    private TransactionsParser() {
    }

    public static TransactionsResponse camtStringToLoadBookingsResponse(String body) {
        SepaVersion version = SepaVersion.autodetect((String)body);
        ISEPAParser parser = SEPAParserFactory.get((SepaVersion)version);
        GVRKUms bookingsResult = new GVRKUms(null);
        parser.parse((InputStream)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)), (Object)bookingsResult.getDataPerDay());
        return TransactionsParser.jobresultToLoadBookingsResponse(bookingsResult, body);
    }

    public static TransactionsResponse mt940StringToLoadBookingsResponse(String body) {
        GVRKUms bookingsResult = new GVRKUms(null);
        bookingsResult.appendMt940raw(new StringBuilder(Swift.decodeUmlauts((String)body)));
        return TransactionsParser.jobresultToLoadBookingsResponse(bookingsResult, body);
    }

    private static TransactionsResponse jobresultToLoadBookingsResponse(GVRKUms bookingsResult, String raw) {
        List bookings = accountStatementMapper.createBookings(bookingsResult).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Booking>(Comparator.comparing(Booking::getExternalId))), ArrayList::new));
        BalancesReport balancesReport = null;
        if (!bookingsResult.getDataPerDay().isEmpty()) {
            GVRKUms.BTag lastBoookingDay = (GVRKUms.BTag)bookingsResult.getDataPerDay().get(bookingsResult.getDataPerDay().size() - 1);
            if (lastBoookingDay.end != null && lastBoookingDay.end.timestamp != null) {
                balancesReport = TransactionsParser.createBalancesReport(lastBoookingDay.end);
            }
        }
        return TransactionsResponse.builder().bookings(bookings).balancesReport(balancesReport).rawData(Collections.singletonList(raw)).build();
    }

    private static BalancesReport createBalancesReport(Saldo saldo) {
        BalancesReport balancesReport = new BalancesReport();
        balancesReport.setReadyBalance(accountStatementMapper.toBalance(saldo));
        return balancesReport;
    }
}

