/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.model;

import de.adorsys.multibanking.domain.Credentials;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.TanTransportType;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kapott.hbci.manager.HBCIProduct;

public class HbciConsent {
    private HBCIProduct hbciProduct;
    private ScaStatus status;
    private Credentials credentials;
    private List<TanTransportType> tanMethodList;
    private TanTransportType selectedMethod;
    private String scaAuthenticationData;
    private Object hbciTanSubmit;
    private boolean withHktan = true;
    private boolean closeDialog = true;
    private LocalDateTime hbciCacheUpdateTime;
    private String hbciSysId;
    private Map<String, String> hbciUpd;

    public void afterTransactionAuthorisation(ScaStatus scaStatus) {
        this.setHbciTanSubmit(null);
        this.setStatus(scaStatus);
        this.setScaAuthenticationData(null);
    }

    public void checkUpdCache(long sysIdExpirationTimeMs, long updExpirationTimeMs) {
        Optional.ofNullable(this.hbciCacheUpdateTime).ifPresent(cacheUpdateTime -> {
            if (cacheUpdateTime.plus(sysIdExpirationTimeMs, ChronoUnit.MILLIS).isBefore(LocalDateTime.now())) {
                this.hbciSysId = null;
            }
            if (cacheUpdateTime.plus(updExpirationTimeMs, ChronoUnit.MILLIS).isBefore(LocalDateTime.now())) {
                this.hbciUpd = null;
            }
        });
    }

    public HbciConsent() {
    }

    public HbciConsent(HBCIProduct hbciProduct, ScaStatus status, Credentials credentials, List<TanTransportType> tanMethodList, TanTransportType selectedMethod, String scaAuthenticationData, Object hbciTanSubmit, boolean withHktan, boolean closeDialog, LocalDateTime hbciCacheUpdateTime, String hbciSysId, Map<String, String> hbciUpd) {
        this.hbciProduct = hbciProduct;
        this.status = status;
        this.credentials = credentials;
        this.tanMethodList = tanMethodList;
        this.selectedMethod = selectedMethod;
        this.scaAuthenticationData = scaAuthenticationData;
        this.hbciTanSubmit = hbciTanSubmit;
        this.withHktan = withHktan;
        this.closeDialog = closeDialog;
        this.hbciCacheUpdateTime = hbciCacheUpdateTime;
        this.hbciSysId = hbciSysId;
        this.hbciUpd = hbciUpd;
    }

    public HBCIProduct getHbciProduct() {
        return this.hbciProduct;
    }

    public ScaStatus getStatus() {
        return this.status;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public List<TanTransportType> getTanMethodList() {
        return this.tanMethodList;
    }

    public TanTransportType getSelectedMethod() {
        return this.selectedMethod;
    }

    public String getScaAuthenticationData() {
        return this.scaAuthenticationData;
    }

    public Object getHbciTanSubmit() {
        return this.hbciTanSubmit;
    }

    public boolean isWithHktan() {
        return this.withHktan;
    }

    public boolean isCloseDialog() {
        return this.closeDialog;
    }

    public LocalDateTime getHbciCacheUpdateTime() {
        return this.hbciCacheUpdateTime;
    }

    public String getHbciSysId() {
        return this.hbciSysId;
    }

    public Map<String, String> getHbciUpd() {
        return this.hbciUpd;
    }

    public void setHbciProduct(HBCIProduct hbciProduct) {
        this.hbciProduct = hbciProduct;
    }

    public void setStatus(ScaStatus status) {
        this.status = status;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setTanMethodList(List<TanTransportType> tanMethodList) {
        this.tanMethodList = tanMethodList;
    }

    public void setSelectedMethod(TanTransportType selectedMethod) {
        this.selectedMethod = selectedMethod;
    }

    public void setScaAuthenticationData(String scaAuthenticationData) {
        this.scaAuthenticationData = scaAuthenticationData;
    }

    public void setHbciTanSubmit(Object hbciTanSubmit) {
        this.hbciTanSubmit = hbciTanSubmit;
    }

    public void setWithHktan(boolean withHktan) {
        this.withHktan = withHktan;
    }

    public void setCloseDialog(boolean closeDialog) {
        this.closeDialog = closeDialog;
    }

    public void setHbciCacheUpdateTime(LocalDateTime hbciCacheUpdateTime) {
        this.hbciCacheUpdateTime = hbciCacheUpdateTime;
    }

    public void setHbciSysId(String hbciSysId) {
        this.hbciSysId = hbciSysId;
    }

    public void setHbciUpd(Map<String, String> hbciUpd) {
        this.hbciUpd = hbciUpd;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HbciConsent)) {
            return false;
        }
        HbciConsent other = (HbciConsent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HBCIProduct this$hbciProduct = this.getHbciProduct();
        HBCIProduct other$hbciProduct = other.getHbciProduct();
        if (this$hbciProduct == null ? other$hbciProduct != null : !this$hbciProduct.equals(other$hbciProduct)) {
            return false;
        }
        ScaStatus this$status = this.getStatus();
        ScaStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Credentials this$credentials = this.getCredentials();
        Credentials other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        List<TanTransportType> this$tanMethodList = this.getTanMethodList();
        List<TanTransportType> other$tanMethodList = other.getTanMethodList();
        if (this$tanMethodList == null ? other$tanMethodList != null : !((Object)this$tanMethodList).equals(other$tanMethodList)) {
            return false;
        }
        TanTransportType this$selectedMethod = this.getSelectedMethod();
        TanTransportType other$selectedMethod = other.getSelectedMethod();
        if (this$selectedMethod == null ? other$selectedMethod != null : !this$selectedMethod.equals(other$selectedMethod)) {
            return false;
        }
        String this$scaAuthenticationData = this.getScaAuthenticationData();
        String other$scaAuthenticationData = other.getScaAuthenticationData();
        if (this$scaAuthenticationData == null ? other$scaAuthenticationData != null : !this$scaAuthenticationData.equals(other$scaAuthenticationData)) {
            return false;
        }
        Object this$hbciTanSubmit = this.getHbciTanSubmit();
        Object other$hbciTanSubmit = other.getHbciTanSubmit();
        if (this$hbciTanSubmit == null ? other$hbciTanSubmit != null : !this$hbciTanSubmit.equals(other$hbciTanSubmit)) {
            return false;
        }
        if (this.isWithHktan() != other.isWithHktan()) {
            return false;
        }
        if (this.isCloseDialog() != other.isCloseDialog()) {
            return false;
        }
        LocalDateTime this$hbciCacheUpdateTime = this.getHbciCacheUpdateTime();
        LocalDateTime other$hbciCacheUpdateTime = other.getHbciCacheUpdateTime();
        if (this$hbciCacheUpdateTime == null ? other$hbciCacheUpdateTime != null : !((Object)this$hbciCacheUpdateTime).equals(other$hbciCacheUpdateTime)) {
            return false;
        }
        String this$hbciSysId = this.getHbciSysId();
        String other$hbciSysId = other.getHbciSysId();
        if (this$hbciSysId == null ? other$hbciSysId != null : !this$hbciSysId.equals(other$hbciSysId)) {
            return false;
        }
        Map<String, String> this$hbciUpd = this.getHbciUpd();
        Map<String, String> other$hbciUpd = other.getHbciUpd();
        return !(this$hbciUpd == null ? other$hbciUpd != null : !((Object)this$hbciUpd).equals(other$hbciUpd));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HbciConsent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HBCIProduct $hbciProduct = this.getHbciProduct();
        result = result * 59 + ($hbciProduct == null ? 43 : $hbciProduct.hashCode());
        ScaStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Credentials $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        List<TanTransportType> $tanMethodList = this.getTanMethodList();
        result = result * 59 + ($tanMethodList == null ? 43 : ((Object)$tanMethodList).hashCode());
        TanTransportType $selectedMethod = this.getSelectedMethod();
        result = result * 59 + ($selectedMethod == null ? 43 : $selectedMethod.hashCode());
        String $scaAuthenticationData = this.getScaAuthenticationData();
        result = result * 59 + ($scaAuthenticationData == null ? 43 : $scaAuthenticationData.hashCode());
        Object $hbciTanSubmit = this.getHbciTanSubmit();
        result = result * 59 + ($hbciTanSubmit == null ? 43 : $hbciTanSubmit.hashCode());
        result = result * 59 + (this.isWithHktan() ? 79 : 97);
        result = result * 59 + (this.isCloseDialog() ? 79 : 97);
        LocalDateTime $hbciCacheUpdateTime = this.getHbciCacheUpdateTime();
        result = result * 59 + ($hbciCacheUpdateTime == null ? 43 : ((Object)$hbciCacheUpdateTime).hashCode());
        String $hbciSysId = this.getHbciSysId();
        result = result * 59 + ($hbciSysId == null ? 43 : $hbciSysId.hashCode());
        Map<String, String> $hbciUpd = this.getHbciUpd();
        result = result * 59 + ($hbciUpd == null ? 43 : ((Object)$hbciUpd).hashCode());
        return result;
    }

    public String toString() {
        return "HbciConsent(hbciProduct=" + this.getHbciProduct() + ", status=" + this.getStatus() + ", credentials=" + this.getCredentials() + ", tanMethodList=" + this.getTanMethodList() + ", selectedMethod=" + this.getSelectedMethod() + ", scaAuthenticationData=" + this.getScaAuthenticationData() + ", hbciTanSubmit=" + this.getHbciTanSubmit() + ", withHktan=" + this.isWithHktan() + ", closeDialog=" + this.isCloseDialog() + ", hbciCacheUpdateTime=" + this.getHbciCacheUpdateTime() + ", hbciSysId=" + this.getHbciSysId() + ", hbciUpd=" + this.getHbciUpd() + ")";
    }
}

