/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.AbstractRequest;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.domain.response.TransactionAuthorisationResponse;
import de.adorsys.multibanking.domain.transaction.AbstractPayment;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.TransactionAuthorisation;
import de.adorsys.multibanking.hbci.HbciCacheHandler;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciPassport;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.callback.AbstractHBCICallback;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.dialog.HBCIJobsDialog;
import org.kapott.hbci.manager.KnownTANProcess;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionAuthorisationJob<T extends AbstractTransaction, R extends AbstractResponse> {
    private static final Logger log = LoggerFactory.getLogger(TransactionAuthorisationJob.class);
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).findAndRegisterModules();
    private final ScaAwareJob<T, R> scaJob;
    private final TransactionAuthorisation<T> transactionAuthorisation;

    public TransactionAuthorisationResponse<R> execute() {
        HbciConsent consent = (HbciConsent)this.transactionAuthorisation.getOriginTransactionRequest().getBankApiConsentData();
        HbciTanSubmit hbciTanSubmit = this.evaluateTanSubmit(consent);
        HbciPassport hbciPassport = this.createPassport(this.transactionAuthorisation, hbciTanSubmit);
        HBCIJobsDialog hbciDialog = new HBCIJobsDialog((PinTanPassport)hbciPassport, hbciTanSubmit.getDialogId(), hbciTanSubmit.getMsgNum());
        if (hbciTanSubmit.getTwoStepMechanism().getProcess() == 1) {
            this.submitProcess1(hbciTanSubmit, hbciPassport, hbciDialog);
        } else {
            this.submitProcess2(hbciTanSubmit, hbciDialog);
        }
        HBCIExecStatus hbciExecStatus = hbciDialog.execute(false);
        if (!hbciExecStatus.isOK()) {
            if (consent.isCloseDialog()) {
                hbciDialog.dialogEnd();
            }
            throw new MultibankingException(MultibankingError.HBCI_ERROR, this.scaJob.msgStatusListToPsuMessages(hbciExecStatus.getMsgStatusList()));
        }
        if ("HKIDN".equals(hbciTanSubmit.getHbciJobName())) {
            TransactionAuthorisationResponse response = new TransactionAuthorisationResponse(this.scaJob.execute(null, hbciDialog));
            response.setScaStatus(ScaStatus.FINALISED);
            return response;
        }
        if (consent.isCloseDialog()) {
            hbciDialog.dialogEnd();
        }
        return this.createResponse(hbciPassport, hbciTanSubmit);
    }

    private void submitProcess1(HbciTanSubmit hbciTanSubmit, HbciPassport hbciPassport, HBCIJobsDialog hbciDialog) {
        AbstractHBCIJob hbciJob = this.scaJob.createJobMessage(hbciPassport);
        if (hbciTanSubmit.getSepaPain() != null) {
            hbciJob.getConstraints().remove("_sepapain");
            hbciJob.setLowlevelParam(hbciJob.getName() + ".sepapain", hbciTanSubmit.getSepaPain());
        }
        hbciDialog.addTask(hbciJob);
    }

    private void submitProcess2(HbciTanSubmit hbciTanSubmit, HBCIJobsDialog hbciDialog) {
        AbstractHBCIJob originJob = Optional.ofNullable(hbciTanSubmit.getOriginJobName()).map(originJobName -> {
            AbstractHBCIJob result = this.scaJob.createJobMessage(hbciDialog.getPassport());
            try {
                result.setLlParams((Map)objectMapper.readValue(hbciTanSubmit.getLowLevelParams(), HashMap.class));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new MultibankingException(MultibankingError.INTERNAL_ERROR, 500, e.getMessage());
            }
            result.setSegVersion(hbciTanSubmit.getOriginSegVersion());
            return result;
        }).orElse(null);
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)hbciDialog.getPassport(), originJob);
        hktan.setProcess(KnownTANProcess.PROCESS2_STEP2);
        Optional.ofNullable(hbciTanSubmit.getHbciJobName()).ifPresent(hbciSegCode -> hktan.setParam("ordersegcode", hbciSegCode));
        hktan.setParam("orderref", hbciTanSubmit.getOrderRef());
        hktan.setParam("process", hbciTanSubmit.getHktanProcess() != null ? hbciTanSubmit.getHktanProcess() : "2");
        hktan.setParam("notlasttan", "N");
        hbciDialog.addTask((AbstractHBCIJob)hktan, false);
    }

    private TransactionAuthorisationResponse<R> createResponse(PinTanPassport passport, HbciTanSubmit hbciTanSubmit) {
        TransactionAuthorisationResponse response = new TransactionAuthorisationResponse(this.scaJob.createJobResponse(passport, hbciTanSubmit));
        ScaStatus scaStatus = Optional.ofNullable(hbciTanSubmit.getHbciJobName()).map(hbciJobName -> hbciJobName.equals("HKIDN") || this.scaJob.getTransactionRequest().getTransaction() instanceof AbstractPayment).map(finalised -> Boolean.TRUE.equals(finalised) ? ScaStatus.FINALISED : ScaStatus.SCAMETHODSELECTED).orElse(ScaStatus.FINALISED);
        response.setScaStatus(scaStatus);
        return response;
    }

    private HbciTanSubmit evaluateTanSubmit(HbciConsent hbciConsent) {
        if (hbciConsent.getHbciTanSubmit() instanceof HbciTanSubmit) {
            return (HbciTanSubmit)hbciConsent.getHbciTanSubmit();
        }
        return this.deserializeTanSubmit((byte[])hbciConsent.getHbciTanSubmit());
    }

    private HbciTanSubmit deserializeTanSubmit(byte[] data) {
        try {
            return (HbciTanSubmit)objectMapper.readValue(data, HbciTanSubmit.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not deserialize HbciTanSubmit", e);
        }
    }

    private HbciPassport createPassport(final TransactionAuthorisation<T> transactionAuthorisation, HbciTanSubmit hbciTanSubmit) {
        Map bpd = Optional.ofNullable(HbciCacheHandler.getBpd((AbstractRequest)transactionAuthorisation.getOriginTransactionRequest())).orElseGet(() -> this.scaJob.fetchBpd(null).getBPD());
        HbciPassport.State state = HbciPassport.State.fromJson(hbciTanSubmit.getPassportState());
        HbciPassport hbciPassport = HbciDialogFactory.createPassport(state, (HBCICallback)new AbstractHBCICallback(){

            public String needTAN() {
                return ((HbciConsent)transactionAuthorisation.getOriginTransactionRequest().getBankApiConsentData()).getScaAuthenticationData();
            }
        });
        state.apply(hbciPassport);
        HbciConsent hbciConsent = (HbciConsent)transactionAuthorisation.getOriginTransactionRequest().getBankApiConsentData();
        hbciPassport.setPIN(hbciConsent.getCredentials().getPin());
        hbciPassport.setCurrentSecMechInfo(hbciTanSubmit.getTwoStepMechanism());
        hbciPassport.setBPD(bpd);
        return hbciPassport;
    }

    public TransactionAuthorisationJob(ScaAwareJob<T, R> scaJob, TransactionAuthorisation<T> transactionAuthorisation) {
        this.scaJob = scaJob;
        this.transactionAuthorisation = transactionAuthorisation;
    }
}

