/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.StandingOrderRequest;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import de.adorsys.multibanking.hbci.model.HbciCycleMapper;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVDauerSEPADel;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteStandingOrderJob
extends AbstractPaymentJob<StandingOrderRequest> {
    private static final Logger log = LoggerFactory.getLogger(DeleteStandingOrderJob.class);
    private final TransactionRequest<StandingOrderRequest> transactionRequest;
    private GVDauerSEPADel hbciDeleteStandingOrderJob;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        StandingOrderRequest standingOrder = (StandingOrderRequest)this.transactionRequest.getTransaction();
        Konto src = this.getPsuKonto(passport);
        Konto dst = new Konto();
        dst.name = standingOrder.getOtherAccount().getOwner();
        dst.iban = standingOrder.getOtherAccount().getIban();
        dst.bic = standingOrder.getOtherAccount().getBic();
        this.hbciDeleteStandingOrderJob = new GVDauerSEPADel((HBCIPassportInternal)passport);
        this.hbciDeleteStandingOrderJob.setParam("src", src);
        this.hbciDeleteStandingOrderJob.setParam("dst", dst);
        this.hbciDeleteStandingOrderJob.setParam("btg", new Value(standingOrder.getAmount(), standingOrder.getCurrency()));
        this.hbciDeleteStandingOrderJob.setParam("usage", standingOrder.getUsage());
        this.hbciDeleteStandingOrderJob.setParam("orderid", standingOrder.getOrderId());
        if (standingOrder.getFirstExecutionDate() != null) {
            this.hbciDeleteStandingOrderJob.setParam("firstdate", standingOrder.getFirstExecutionDate().toString());
        }
        if (standingOrder.getCycle() != null) {
            this.hbciDeleteStandingOrderJob.setParam("timeunit", HbciCycleMapper.cycleToTimeunit(standingOrder.getCycle()));
            this.hbciDeleteStandingOrderJob.setParam("turnus", HbciCycleMapper.cycleToTurnus(standingOrder.getCycle()));
        }
        this.hbciDeleteStandingOrderJob.setParam("execday", standingOrder.getExecutionDay());
        if (standingOrder.getLastExecutionDate() != null) {
            this.hbciDeleteStandingOrderJob.setParam("lastdate", standingOrder.getLastExecutionDate().toString());
        }
        this.hbciDeleteStandingOrderJob.verifyConstraints();
        return this.hbciDeleteStandingOrderJob;
    }

    @Override
    AbstractHBCIJob getHbciJob() {
        return this.hbciDeleteStandingOrderJob;
    }

    @Override
    TransactionRequest<StandingOrderRequest> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    protected String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        return GVDauerSEPADel.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return null;
    }

    public DeleteStandingOrderJob(TransactionRequest<StandingOrderRequest> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

