/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.ChallengeData;
import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.AbstractRequest;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.hbci.HbciBpdCacheHolder;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciDialogRequest;
import de.adorsys.multibanking.hbci.model.HbciDialogRequestMapper;
import de.adorsys.multibanking.hbci.model.HbciDialogRequestMapperImpl;
import de.adorsys.multibanking.hbci.model.HbciDialogType;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import de.adorsys.multibanking.hbci.util.HbciErrorUtils;
import de.adorsys.multibanking.mapper.AccountStatementMapper;
import de.adorsys.multibanking.mapper.AccountStatementMapperImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.iban4j.Iban;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV.GVVeuStep;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.callback.AbstractHBCICallback;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.dialog.AbstractHbciDialog;
import org.kapott.hbci.dialog.HBCIJobsDialog;
import org.kapott.hbci.manager.ChallengeInfo;
import org.kapott.hbci.manager.HBCIMessage;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.manager.KnownReturncode;
import org.kapott.hbci.manager.KnownTANProcess;
import org.kapott.hbci.manager.MatrixCode;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScaAwareJob<T extends AbstractTransaction, R extends AbstractResponse> {
    private static final Logger log = LoggerFactory.getLogger(ScaAwareJob.class);
    private static final HbciDialogRequestMapper hbciDialogRequestMapper = new HbciDialogRequestMapperImpl();
    static AccountStatementMapper accountStatementMapper = new AccountStatementMapperImpl();
    final TransactionRequest<T> transactionRequest;
    private final HbciBpdCacheHolder hbciBpdCacheHolder;
    HBCIJobsDialog dialog;
    AbstractHBCIJob hbciJob;
    HbciTanSubmit hbciTanSubmit = new HbciTanSubmit();
    private UpdateAuthResponse challenge;

    public R execute(HBCICallback hbciCallback) {
        R jobResponse;
        if (this.dialog == null && (jobResponse = this.initDialog(hbciCallback)) != null) {
            return jobResponse;
        }
        AbstractHBCIJob newHbciJob = this.getOrCreateHbciJob();
        boolean tan2StepRequired = newHbciJob == null || this.dialog.getPassport().tan2StepRequired(newHbciJob);
        GVTAN2Step hktan = null;
        if (tan2StepRequired) {
            hktan = this.prepareHbciMessagefor2FA();
        } else {
            this.dialog.addTask(newHbciJob);
        }
        HBCIExecStatus hbciExecStatus = this.dialog.execute(false);
        this.checkExecuteStatus(hbciExecStatus);
        tan2StepRequired = Optional.ofNullable(hktan).map(gvtan2Step -> !this.isScaExempted(hbciExecStatus, gvtan2Step.getJobResult())).orElse(false);
        R jobResponse2 = this.createJobResponse();
        jobResponse2.setMessages(HbciErrorUtils.msgStatusListToMessages(hbciExecStatus.getMsgStatusList()));
        if (tan2StepRequired) {
            this.hbciTanSubmit.update((AbstractHbciDialog)this.dialog, newHbciJob, this.getHbciJobName(), this.getUserTanTransportType(this.dialog.getPassport().getBankTwostepMechanisms()), this.getHbciKonto());
            jobResponse2.setAuthorisationCodeResponse(new AuthorisationCodeResponse((Object)this.hbciTanSubmit, this.challenge));
        } else if (this.getConsent().isCloseDialog()) {
            this.dialog.dialogEnd();
        }
        return jobResponse2;
    }

    private boolean isScaExempted(HBCIExecStatus hbciExecStatus, HBCIJobResult hbciJobResult) {
        return KnownReturncode.W3076.searchReturnValue(hbciJobResult.getJobStatus().getRetVals()) != null || KnownReturncode.W3076.searchReturnValue(hbciJobResult.getGlobStatus().getRetVals()) != null || hbciExecStatus.getMsgStatusList().stream().filter(Objects::nonNull).anyMatch(hbciMsgStatus -> KnownReturncode.W3076.searchReturnValue(hbciMsgStatus.globStatus.getRetVals()) != null || KnownReturncode.W3076.searchReturnValue(hbciMsgStatus.segStatus.getRetVals()) != null);
    }

    private R initDialog(HBCICallback hbciCallback) {
        log.debug("init new hbci dialog");
        PinTanPassport bpdPassport = this.fetchBpd(hbciCallback);
        this.dialog = (HBCIJobsDialog)this.createDialog(HbciDialogType.JOBS, hbciCallback, this.getUserTanTransportType(bpdPassport.getBankTwostepMechanisms()), bpdPassport.getBPD());
        HBCIMsgStatus dialogInitMsgStatus = this.dialog.dialogInit(this.getConsent().isWithHktan());
        if (this.checkDialogInitScaRequired(dialogInitMsgStatus)) {
            log.debug("HKIDN SCA required");
            R jobResponse = this.createJobResponse();
            jobResponse.setAuthorisationCodeResponse(new AuthorisationCodeResponse((Object)this.hbciTanSubmit, this.challenge));
            return jobResponse;
        }
        return null;
    }

    private boolean checkDialogInitScaRequired(HBCIMsgStatus initMsgStatus) {
        if (!initMsgStatus.isOK()) {
            throw HbciErrorUtils.toMultibankingException(Collections.singletonList(initMsgStatus));
        }
        boolean scaRequired = initMsgStatus.segStatus.getRetVals().stream().anyMatch(hbciRetVal -> hbciRetVal.code.equals("0030"));
        if (scaRequired) {
            HBCITwoStepMechanism userTanTransportType = this.getUserTanTransportType(this.dialog.getPassport().getBankTwostepMechanisms());
            this.hbciTanSubmit.update((AbstractHbciDialog)this.dialog, this.getOrCreateHbciJob(), this.getHbciJobName(), userTanTransportType, this.getHbciKonto());
            this.hbciTanSubmit.setHbciJobName("HKIDN");
            String header = "TAN2StepRes" + userTanTransportType.getSegversion();
            this.dialog.getPassport().getCallback().tanChallengeCallback((String)initMsgStatus.getData().get(header + ".orderref"), (String)initMsgStatus.getData().get(header + ".challenge"), (String)initMsgStatus.getData().get(header + ".challenge_hhd_uc"), null);
        }
        return scaRequired;
    }

    PinTanPassport fetchBpd(HBCICallback hbciCallback) {
        AbstractHbciDialog bpdDialog = this.createDialog(HbciDialogType.BPD, hbciCallback, null, null);
        bpdDialog.execute(true);
        return bpdDialog.getPassport();
    }

    private GVTAN2Step prepareHbciMessagefor2FA() {
        HBCITwoStepMechanism hbciTwoStepMechanism = this.getUserTanTransportType(this.dialog.getPassport().getBankTwostepMechanisms());
        if (hbciTwoStepMechanism.getProcess() == 1 && this.getOrCreateHbciJob() == null) {
            throw new MultibankingException(MultibankingError.INTERNAL_ERROR, "Tan requests without corresponding transaction not supported with HKTAN process variant 1");
        }
        if (this.getOrCreateHbciJob() == null || hbciTwoStepMechanism.getProcess() == 2) {
            return this.hktanProcess2(hbciTwoStepMechanism);
        }
        return this.hktanProcess1(hbciTwoStepMechanism);
    }

    private AbstractHbciDialog createDialog(HbciDialogType dialogType, HBCICallback hbciCallback, HBCITwoStepMechanism twoStepMechanism, Map<String, String> bpd) {
        HBCICallback callback = this.createCallback(hbciCallback);
        HbciDialogRequest dialogRequest = this.createDialogRequest(callback);
        bpd = Optional.ofNullable(bpd).orElseGet(() -> this.hbciBpdCacheHolder.getBpd(dialogRequest));
        return HbciDialogFactory.createDialog(dialogType, dialogRequest, twoStepMechanism, bpd);
    }

    void checkExecuteStatus(HBCIExecStatus execStatus) {
        if (!execStatus.isOK()) {
            throw HbciErrorUtils.toMultibankingException(execStatus.getMsgStatusList());
        }
    }

    private GVTAN2Step hktanProcess1(HBCITwoStepMechanism hbciTwoStepMechanism) {
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)this.dialog.getPassport(), this.getOrCreateHbciJob());
        hktan.setProcess(KnownTANProcess.PROCESS1);
        hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
        if (this.dialog.getPassport().tanMediaNeeded()) {
            hktan.setParam("tanmedia", this.getConsent().getSelectedMethod().getMedium());
        }
        hktan.setParam("notlasttan", "N");
        hktan.setParam("orderhash", this.getOrCreateHbciJob().createOrderHash(hbciTwoStepMechanism.getSegversion()));
        if (StringUtils.equals((CharSequence)hbciTwoStepMechanism.getNeedchallengeklass(), (CharSequence)"J")) {
            ChallengeInfo cinfo = ChallengeInfo.getInstance();
            cinfo.applyParams(this.getOrCreateHbciJob(), (AbstractHBCIJob)hktan, hbciTwoStepMechanism);
        }
        this.hbciTanSubmit.setSepaPain(this.getOrCreateHbciJob().getRawData());
        this.dialog.addTask((AbstractHBCIJob)hktan, false);
        return hktan;
    }

    private GVTAN2Step hktanProcess2(HBCITwoStepMechanism hbciTwoStepMechanism) {
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)this.dialog.getPassport(), this.getOrCreateHbciJob());
        hktan.setProcess(KnownTANProcess.PROCESS2_STEP1);
        hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
        if (this.dialog.getPassport().tanMediaNeeded()) {
            hktan.setParam("tanmedia", this.getConsent().getSelectedMethod().getMedium());
        }
        hktan.setParam("orderaccount", this.getHbciKonto());
        Optional.ofNullable(this.getOrCreateHbciJob()).map(AbstractHBCIJob::getHBCICode).ifPresent(hbciCode -> hktan.setParam("ordersegcode", hbciCode));
        Optional<HBCIMessage> hbciMessage = Optional.ofNullable(this.getOrCreateHbciJob()).map(abstractHBCIJob -> this.dialog.addTask(abstractHBCIJob).append((AbstractHBCIJob)hktan));
        if (!hbciMessage.isPresent()) {
            this.dialog.addTask((AbstractHBCIJob)hktan);
        }
        return hktan;
    }

    Konto getHbciKonto() {
        return this.getPsuAccount().map(account -> {
            String accountNumber = account.getAccountNumber() != null ? account.getAccountNumber() : Iban.valueOf((String)account.getIban()).getAccountNumber();
            Konto konto = this.dialog.getPassport().findAccountByAccountNumber(accountNumber);
            konto.iban = account.getIban();
            if (konto.bic == null) {
                konto.bic = Optional.ofNullable(account.getBic()).orElseGet(() -> HBCIUtils.getBankInfo((String)konto.blz).getBic());
            }
            return konto;
        }).orElseGet(this::getFirstAccount);
    }

    private Konto getFirstAccount() {
        return Optional.of(this.dialog.getPassport().getAccounts()).map(kontos -> !kontos.isEmpty() ? (Konto)kontos.get(0) : null).orElse(null);
    }

    private Optional<BankAccount> getPsuAccount() {
        return Optional.ofNullable(this.transactionRequest.getTransaction().getPsuAccount());
    }

    private HBCITwoStepMechanism getUserTanTransportType(Map<String, HBCITwoStepMechanism> bpdScaMethods) {
        return Optional.ofNullable(this.getConsent().getSelectedMethod()).map(tanTransportType -> (HBCITwoStepMechanism)bpdScaMethods.get(tanTransportType.getId())).map(hbciTwoStepMechanism -> {
            hbciTwoStepMechanism.setMedium(this.getConsent().getSelectedMethod().getMedium());
            return hbciTwoStepMechanism;
        }).orElseGet(() -> {
            HBCITwoStepMechanism hbciTwoStepMechanism = new HBCITwoStepMechanism();
            hbciTwoStepMechanism.setSecfunc("999");
            hbciTwoStepMechanism.setSegversion(6);
            hbciTwoStepMechanism.setProcess(2);
            hbciTwoStepMechanism.setId("999");
            return hbciTwoStepMechanism;
        });
    }

    private HBCICallback createCallback(final HBCICallback hbciCallback) {
        return new AbstractHBCICallback(){

            public void tanChallengeCallback(String orderRef, String challengeInfo, String challengeHhdUc, HHDVersion.Type type) {
                ScaAwareJob.this.hbciTanSubmit.setOrderRef(orderRef);
                ScaAwareJob.this.challenge = new UpdateAuthResponse(BankApi.HBCI, ScaApproach.EMBEDDED, ScaStatus.SCAMETHODSELECTED);
                ChallengeData challengeData = new ChallengeData();
                challengeData.setAdditionalInformation(challengeInfo);
                ScaAwareJob.this.challenge.setChallenge(challengeData);
                if (challengeHhdUc != null) {
                    MatrixCode matrixCode = MatrixCode.tryParse((String)challengeHhdUc);
                    if (matrixCode != null) {
                        challengeData.setImage(Base64.encodeBase64String((byte[])matrixCode.getImage()));
                    } else {
                        challengeData.setData(Collections.singletonList(challengeHhdUc));
                    }
                }
            }

            public void status(int statusTag, Object o) {
                Optional.ofNullable(hbciCallback).ifPresent(callback -> callback.status(statusTag, o));
            }

            public void status(int statusTag, Object[] o) {
                Optional.ofNullable(hbciCallback).ifPresent(callback -> callback.status(statusTag, o));
            }
        };
    }

    private HbciDialogRequest createDialogRequest(HBCICallback hbciCallback) {
        return hbciDialogRequestMapper.toHbciDialogRequest((AbstractRequest)this.transactionRequest, hbciCallback);
    }

    AbstractHBCIJob getOrCreateHbciJob() {
        if (this.hbciJob == null) {
            this.hbciJob = this.checkVeu().orElseGet(this::createHbciJob);
        }
        return this.hbciJob;
    }

    private Optional<AbstractHBCIJob> checkVeu() {
        if (this.transactionRequest.getTransaction().isVeu2ndSignature()) {
            GVVeuStep veuStep = new GVVeuStep((HBCIPassportInternal)this.dialog.getPassport());
            veuStep.setParam("orderref", this.transactionRequest.getTransaction().getOrderId());
            veuStep.setParam("my", this.getHbciKonto());
            return Optional.of(veuStep);
        }
        return Optional.empty();
    }

    private HbciConsent getConsent() {
        return (HbciConsent)this.transactionRequest.getBankApiConsentData();
    }

    abstract String getHbciJobName();

    abstract AbstractHBCIJob createHbciJob();

    abstract R createJobResponse();

    public ScaAwareJob(TransactionRequest<T> transactionRequest, HbciBpdCacheHolder hbciBpdCacheHolder) {
        this.transactionRequest = transactionRequest;
        this.hbciBpdCacheHolder = hbciBpdCacheHolder;
    }

    public HbciBpdCacheHolder getHbciBpdCacheHolder() {
        return this.hbciBpdCacheHolder;
    }
}

