/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.PeriodicPayment;
import de.adorsys.multibanking.hbci.HbciBpdCacheHolder;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import de.adorsys.multibanking.hbci.model.HbciCycleMapper;
import org.kapott.hbci.GV.GVDauerSEPANew;
import org.kapott.hbci.GV_Result.GVRPayment;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicPaymentJob
extends AbstractPaymentJob<PeriodicPayment> {
    private static final Logger log = LoggerFactory.getLogger(PeriodicPaymentJob.class);

    public PeriodicPaymentJob(TransactionRequest<PeriodicPayment> transactionRequest, HbciBpdCacheHolder bpdCacheHolder) {
        super(transactionRequest, bpdCacheHolder);
    }

    GVDauerSEPANew createHbciJob() {
        PeriodicPayment standingOrder = (PeriodicPayment)this.transactionRequest.getTransaction();
        Konto src = this.getHbciKonto();
        Konto dst = new Konto();
        dst.name = standingOrder.getOtherAccount().getOwner();
        dst.iban = standingOrder.getOtherAccount().getIban();
        dst.bic = standingOrder.getOtherAccount().getBic();
        GVDauerSEPANew hbciJob = new GVDauerSEPANew((HBCIPassportInternal)this.dialog.getPassport());
        hbciJob.setParam("src", src);
        hbciJob.setParam("dst", dst);
        hbciJob.setParam("btg", new Value(standingOrder.getAmount(), standingOrder.getCurrency()));
        hbciJob.setParam("usage", standingOrder.getUsage());
        if (standingOrder.getFirstExecutionDate() != null) {
            hbciJob.setParam("firstdate", standingOrder.getFirstExecutionDate().toString());
        }
        if (standingOrder.getCycle() != null) {
            hbciJob.setParam("timeunit", HbciCycleMapper.cycleToTimeunit(standingOrder.getCycle()));
            hbciJob.setParam("turnus", HbciCycleMapper.cycleToTurnus(standingOrder.getCycle()));
        }
        hbciJob.setParam("execday", standingOrder.getExecutionDay());
        if (standingOrder.getLastExecutionDate() != null) {
            hbciJob.setParam("lastdate", standingOrder.getLastExecutionDate().toString());
        }
        if (standingOrder.getPurposecode() != null) {
            hbciJob.setParam("purposecode", standingOrder.getPurposecode());
        }
        if (standingOrder.getEndToEndId() != null) {
            hbciJob.setParam("endtoendid", standingOrder.getEndToEndId());
        }
        hbciJob.verifyConstraints();
        return hbciJob;
    }

    @Override
    protected String getHbciJobName() {
        return GVDauerSEPANew.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return ((GVRPayment)paymentGV).getOrderId();
    }
}

