/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.Booking;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.TransactionsResponse;
import de.adorsys.multibanking.domain.transaction.LoadTransactions;
import de.adorsys.multibanking.hbci.HbciBpdCacheHolder;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import de.adorsys.multibanking.hbci.util.HbciErrorUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVKUmsAll;
import org.kapott.hbci.GV.GVKUmsAllCamt;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Saldo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTransactionsJob
extends ScaAwareJob<LoadTransactions, TransactionsResponse> {
    private static final Logger log = LoggerFactory.getLogger(LoadTransactionsJob.class);

    public LoadTransactionsJob(TransactionRequest<LoadTransactions> transactionRequest, HbciBpdCacheHolder bpdCacheHolder) {
        super(transactionRequest, bpdCacheHolder);
    }

    @Override
    AbstractHBCIJob createHbciJob() {
        return this.createTransactionsJob();
    }

    @Override
    String getHbciJobName() {
        if (this.getOrCreateHbciJob() instanceof GVKUmsAllCamt) {
            return "KUmsAllCamt";
        }
        return "KUmsAll";
    }

    @Override
    public TransactionsResponse createJobResponse() {
        if (this.getOrCreateHbciJob().getJobResult().getJobStatus().hasErrors()) {
            log.error("Bookings job not OK");
            throw HbciErrorUtils.toMultibankingException(this.getOrCreateHbciJob().getJobResult().getJobStatus());
        }
        List bookingList = null;
        BalancesReport balancesReport = null;
        List raw = null;
        GVRKUms bookingsResult = (GVRKUms)this.getOrCreateHbciJob().getJobResult();
        if (((LoadTransactions)this.transactionRequest.getTransaction()).getRawResponseType() != null) {
            raw = bookingsResult.getRaw(((LoadTransactions)this.transactionRequest.getTransaction()).getBookingStatus() == LoadTransactions.BookingStatus.PENDING);
        } else {
            if (((LoadTransactions)this.transactionRequest.getTransaction()).isWithBalance() && !bookingsResult.getDataPerDay().isEmpty()) {
                GVRKUms.BTag lastBoookingDay = (GVRKUms.BTag)bookingsResult.getDataPerDay().get(bookingsResult.getDataPerDay().size() - 1);
                balancesReport = this.createBalancesReport(lastBoookingDay.end);
            }
            bookingList = accountStatementMapper.createBookings(bookingsResult).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Booking>(Comparator.comparing(Booking::getExternalId))), ArrayList::new));
        }
        return TransactionsResponse.builder().bookings(bookingList).balancesReport(balancesReport).rawData(raw).build();
    }

    private BalancesReport createBalancesReport(Saldo saldo) {
        BalancesReport balancesReport = new BalancesReport();
        balancesReport.setReadyBalance(accountStatementMapper.toBalance(saldo));
        return balancesReport;
    }

    private AbstractHBCIJob createTransactionsJob() {
        AbstractHBCIJob hbciJob = this.createBookingsJobInternal();
        hbciJob.setParam("my", this.getHbciKonto());
        LocalDate dateFrom = Optional.ofNullable(((LoadTransactions)this.transactionRequest.getTransaction()).getDateFrom()).orElseGet(() -> this.getStartDate(this.dialog.getPassport().getJobRestrictions(hbciJob.getName())));
        hbciJob.setParam("startdate", Date.from(dateFrom.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        Optional.ofNullable(((LoadTransactions)this.transactionRequest.getTransaction()).getDateTo()).ifPresent(localDate -> hbciJob.setParam("enddate", Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant())));
        return hbciJob;
    }

    private AbstractHBCIJob createBookingsJobInternal() {
        PinTanPassport passport = this.dialog.getPassport();
        LoadTransactions.RawResponseType rawResponseType = ((LoadTransactions)this.transactionRequest.getTransaction()).getRawResponseType();
        if (rawResponseType != null && !passport.jobSupported(rawResponseType == LoadTransactions.RawResponseType.CAMT ? GVKUmsAllCamt.getLowlevelName() : GVKUmsAll.getLowlevelName())) {
            throw new MultibankingException(MultibankingError.BOOKINGS_FORMAT_NOT_SUPPORTED, "hbci transcations format not supported: " + rawResponseType);
        }
        return Optional.ofNullable(rawResponseType).map(format -> {
            if (format == LoadTransactions.RawResponseType.CAMT) {
                return new GVKUmsAllCamt((HBCIPassportInternal)passport, true);
            }
            return new GVKUmsAll((HBCIPassportInternal)passport);
        }).orElseGet(() -> {
            if (passport.jobSupported(GVKUmsAllCamt.getLowlevelName())) {
                return new GVKUmsAllCamt((HBCIPassportInternal)passport, false);
            }
            if (passport.jobSupported(GVKUmsAll.getLowlevelName())) {
                return new GVKUmsAll((HBCIPassportInternal)passport);
            }
            throw new MultibankingException(MultibankingError.HBCI_ERROR, "transaction jobs not supported");
        });
    }

    private LocalDate getStartDate(Map<String, String> jobRestrictions) {
        LocalDate date;
        String days = jobRestrictions.get("timerange");
        if (days != null && days.length() > 0 && days.matches("[0-9]{1,4}")) {
            date = LocalDate.now().minusDays(Long.parseLong(days));
            log.info("earliest start date according to BPD: " + date);
        } else {
            date = LocalDate.now().minusDays(90L);
        }
        return date;
    }
}

