/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.FutureSinglePayment;
import de.adorsys.multibanking.hbci.HbciBpdCacheHolder;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import org.kapott.hbci.GV.GVTermUebSEPADel;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class DeleteFutureSinglePaymentJob
extends AbstractPaymentJob<FutureSinglePayment> {
    private String jobName;

    public DeleteFutureSinglePaymentJob(TransactionRequest<FutureSinglePayment> transactionRequest, HbciBpdCacheHolder bpdCacheHolder) {
        super(transactionRequest, bpdCacheHolder);
    }

    GVTermUebSEPADel createHbciJob() {
        FutureSinglePayment singlePayment = (FutureSinglePayment)this.transactionRequest.getTransaction();
        Konto src = this.getHbciKonto();
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic();
        this.jobName = GVTermUebSEPADel.getLowlevelName();
        GVTermUebSEPADel hbciJob = new GVTermUebSEPADel((HBCIPassportInternal)this.dialog.getPassport(), this.jobName, null);
        hbciJob.setParam("orderid", singlePayment.getOrderId());
        hbciJob.setParam("date", singlePayment.getExecutionDate().toString());
        hbciJob.setParam("src", src);
        hbciJob.setParam("dst", dst);
        hbciJob.setParam("btg", new Value(singlePayment.getAmount(), singlePayment.getCurrency()));
        if (singlePayment.getPurpose() != null) {
            hbciJob.setParam("usage", singlePayment.getPurpose());
        }
        hbciJob.verifyConstraints();
        return hbciJob;
    }

    @Override
    protected String getHbciJobName() {
        return this.jobName;
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return null;
    }
}

