/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci;

import de.adorsys.multibanking.domain.request.AbstractRequest;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class HbciBpdCacheHolder {
    private final long bpdMaxAgeMillis;
    private final Map<String, Map<String, String>> bpdCache = new ConcurrentHashMap<String, Map<String, String>>();

    public Map<String, String> getBpd(AbstractRequest request) {
        String bankCode = Optional.ofNullable(request.getBank().getBankApiBankCode()).orElse(request.getBank().getBankCode());
        return this.getBpd(bankCode);
    }

    public Map<String, String> getBpd(String bankCode) {
        return Optional.ofNullable(this.bpdCache.get(bankCode)).map(bpdMap -> {
            long bpdLastUpdate = Long.parseLong((String)bpdMap.get("_lastupdate"));
            if (System.currentTimeMillis() - bpdLastUpdate < this.bpdMaxAgeMillis) {
                return bpdMap;
            }
            return null;
        }).orElse(null);
    }

    public void updateBpd(String bankCode, Map<String, String> bpd) {
        this.bpdCache.put(bankCode, bpd);
    }

    public HbciBpdCacheHolder(long bpdMaxAgeMillis) {
        this.bpdMaxAgeMillis = bpdMaxAgeMillis;
    }
}

