/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.ConsentStatus;
import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.AbstractRequest;
import de.adorsys.multibanking.domain.request.SelectPsuAuthenticationMethodRequest;
import de.adorsys.multibanking.domain.request.TransactionAuthorisationRequest;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.request.UpdatePsuAuthenticationRequest;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.response.PaymentStatusResponse;
import de.adorsys.multibanking.domain.response.ScaMethodsResponse;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.domain.spi.StrongCustomerAuthorisable;
import de.adorsys.multibanking.domain.transaction.PaymentStatusReqest;
import de.adorsys.multibanking.hbci.HbciBpdCacheHolder;
import de.adorsys.multibanking.hbci.HbciBpdUpdCallback;
import de.adorsys.multibanking.hbci.HbciScaMapper;
import de.adorsys.multibanking.hbci.HbciScaMapperImpl;
import de.adorsys.multibanking.hbci.job.InstantPaymentStatusJob;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciDialogRequest;
import de.adorsys.multibanking.hbci.model.HbciDialogRequestMapper;
import de.adorsys.multibanking.hbci.model.HbciDialogRequestMapperImpl;
import de.adorsys.multibanking.hbci.model.HbciDialogType;
import de.adorsys.multibanking.hbci.util.HbciErrorUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.iban4j.Iban;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTANMediaList;
import org.kapott.hbci.GV_Result.GVRTANMediaList;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.dialog.AbstractHbciDialog;
import org.kapott.hbci.dialog.HBCIJobsDialog;
import org.kapott.hbci.dialog.HBCIUpdDialog;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIProduct;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbciScaHandler
implements StrongCustomerAuthorisable {
    private static final Logger log = LoggerFactory.getLogger(HbciScaHandler.class);
    private final HBCIProduct hbciProduct;
    private final long sysIdMaxAgeMs;
    private final long updMaxAgeMs;
    private final HbciBpdCacheHolder hbciBpdCacheHolder;
    private final HbciScaMapper hbciScaMapper = new HbciScaMapperImpl();
    private final HbciDialogRequestMapper hbciDialogRequestMapper = new HbciDialogRequestMapperImpl();

    public CreateConsentResponse createConsent(Consent consent, boolean redirectPreferred, String tppRedirectUri, Object bankApiConsentData) {
        String bankCode = Iban.valueOf((String)consent.getPsuAccountIban()).getBankCode();
        boolean bankSupported = Optional.ofNullable(HBCIUtils.getBankInfo((String)bankCode)).map(bankInfo -> bankInfo.getPinTanVersion() != null).orElse(false);
        if (!bankSupported) {
            log.error("Bank not supported for bank code " + bankCode);
            throw new MultibankingException(MultibankingError.BANK_NOT_SUPPORTED, 400, "Bank code " + bankCode + " not supported");
        }
        HbciConsent hbciConsent = new HbciConsent();
        hbciConsent.setStatus(ScaStatus.STARTED);
        hbciConsent.setHbciProduct(this.hbciProduct);
        return this.hbciScaMapper.toCreateConsentResponse(hbciConsent);
    }

    public Consent getConsent(String consentId, Object bankApiConsentData) {
        return null;
    }

    public ConsentStatus getConsentStatus(String consentId, Object bankApiConsentData) {
        return null;
    }

    public UpdateAuthResponse updatePsuAuthentication(UpdatePsuAuthenticationRequest updatePsuAuthentication) {
        HbciConsent hbciConsent = (HbciConsent)updatePsuAuthentication.getBankApiConsentData();
        hbciConsent.setCredentials(updatePsuAuthentication.getCredentials());
        ScaMethodsResponse response = this.authenticatePsu(updatePsuAuthentication);
        hbciConsent.setTanMethodList(response.getTanTransportTypes());
        hbciConsent.setStatus(ScaStatus.PSUAUTHENTICATED);
        return this.hbciScaMapper.toUpdateAuthResponse(hbciConsent, new UpdateAuthResponse(BankApi.HBCI, ScaApproach.EMBEDDED, ScaStatus.PSUAUTHENTICATED));
    }

    private ScaMethodsResponse authenticatePsu(UpdatePsuAuthenticationRequest authenticatePsuRequest) {
        try {
            boolean withHktan;
            HbciBpdUpdCallback hbciCallback = HbciBpdUpdCallback.createCallback(authenticatePsuRequest.getBank(), this.hbciBpdCacheHolder);
            HbciDialogRequest dialogRequest = this.hbciDialogRequestMapper.toHbciDialogRequest((AbstractRequest)authenticatePsuRequest, (HBCICallback)hbciCallback);
            HbciConsent hbciConsent = (HbciConsent)authenticatePsuRequest.getBankApiConsentData();
            hbciConsent.checkUpdSysIdCache(this.sysIdMaxAgeMs, this.updMaxAgeMs);
            AbstractHbciDialog dialog = HbciDialogFactory.createDialog(HbciDialogType.BPD, dialogRequest, null, this.hbciBpdCacheHolder.getBpd(dialogRequest));
            HBCIExecStatus bpdExecStatus = dialog.execute(true);
            boolean bl = withHktan = !bpdExecStatus.hasMessage("9400");
            if (!withHktan) {
                hbciConsent.setWithHktan(false);
            }
            PinTanPassport passport = this.fetchUpd(dialogRequest, withHktan, dialog.getPassport().getBPD());
            List<GVRTANMediaList.TANMediaInfo> tanMediaList = null;
            if (passport.jobSupported(GVTANMediaList.getLowlevelName())) {
                tanMediaList = this.fetchTanMedias(passport);
            }
            ScaMethodsResponse response = ScaMethodsResponse.builder().tanTransportTypes(this.extractTanTransportTypes(passport, tanMediaList)).build();
            response.setBankApiConsentData((Object)hbciCallback.updateConsentUpd(hbciConsent));
            return response;
        }
        catch (HBCI_Exception e) {
            throw HbciErrorUtils.handleHbciException(e);
        }
    }

    public UpdateAuthResponse authorizeConsent(TransactionAuthorisationRequest transactionAuthorisationRequest) {
        HbciConsent hbciConsent = (HbciConsent)transactionAuthorisationRequest.getBankApiConsentData();
        hbciConsent.setScaAuthenticationData(transactionAuthorisationRequest.getScaAuthenticationData());
        return this.hbciScaMapper.toUpdateAuthResponse(hbciConsent, new UpdateAuthResponse(BankApi.HBCI, ScaApproach.EMBEDDED, hbciConsent.getStatus()));
    }

    public UpdateAuthResponse selectPsuAuthenticationMethod(SelectPsuAuthenticationMethodRequest selectPsuAuthenticationMethod) {
        HbciConsent hbciConsent = (HbciConsent)selectPsuAuthenticationMethod.getBankApiConsentData();
        TanTransportType selectedMethod = hbciConsent.getTanMethodList().stream().filter(tanTransportType -> tanTransportType.getId().equals(selectPsuAuthenticationMethod.getAuthenticationMethodId())).filter(tanTransportType -> selectPsuAuthenticationMethod.getTanMediaName() == null || selectPsuAuthenticationMethod.getTanMediaName().equals(tanTransportType.getMedium())).findFirst().orElseThrow(() -> new MultibankingException(MultibankingError.INVALID_SCA_METHOD));
        hbciConsent.setSelectedMethod(selectedMethod);
        hbciConsent.setStatus(ScaStatus.SCAMETHODSELECTED);
        return this.hbciScaMapper.toUpdateAuthResponse(hbciConsent, new UpdateAuthResponse(BankApi.HBCI, ScaApproach.EMBEDDED, ScaStatus.SCAMETHODSELECTED));
    }

    public void revokeConsent(String consentId, Object bankApiConsentData) {
    }

    public UpdateAuthResponse getAuthorisationStatus(String consentId, String authorisationId, Object bankApiConsentData) {
        HbciConsent hbciConsent = (HbciConsent)bankApiConsentData;
        return this.hbciScaMapper.toUpdateAuthResponse(hbciConsent, new UpdateAuthResponse(BankApi.HBCI, ScaApproach.EMBEDDED, hbciConsent.getStatus()));
    }

    public void validateConsent(String consentId, String authorisationId, ScaStatus expectedConsentStatus, Object bankApiConsentData) {
        HbciConsent hbciConsent = (HbciConsent)bankApiConsentData;
        if (hbciConsent.getHbciTanSubmit() != null && hbciConsent.getScaAuthenticationData() == null) {
            throw new MultibankingException(MultibankingError.INVALID_CONSENT_STATUS);
        }
        if (hbciConsent.getStatus() == ScaStatus.SCAMETHODSELECTED || hbciConsent.getStatus() == ScaStatus.FINALISED) {
            return;
        }
        throw new MultibankingException(MultibankingError.INVALID_CONSENT_STATUS);
    }

    public void afterExecute(Object bankApiConsentData, AuthorisationCodeResponse authorisationCodeResponse) {
        HbciConsent hbciConsent = (HbciConsent)bankApiConsentData;
        hbciConsent.setHbciTanSubmit(authorisationCodeResponse.getTanSubmit());
    }

    public void submitAuthorisationCode(Object bankApiConsentData, String authorisationCode) {
        throw new UnsupportedOperationException();
    }

    public PaymentStatusResponse getPaymentStatus(TransactionRequest<PaymentStatusReqest> request) {
        try {
            HbciConsent hbciConsent = (HbciConsent)request.getBankApiConsentData();
            hbciConsent.checkUpdSysIdCache(this.sysIdMaxAgeMs, this.updMaxAgeMs);
            HbciBpdUpdCallback hbciCallback = HbciBpdUpdCallback.createCallback(request.getBank(), this.hbciBpdCacheHolder);
            InstantPaymentStatusJob instantPaymentStatusJob = new InstantPaymentStatusJob(request, this.hbciBpdCacheHolder);
            PaymentStatusResponse response = (PaymentStatusResponse)instantPaymentStatusJob.execute((HBCICallback)hbciCallback);
            response.setBankApiConsentData((Object)hbciCallback.updateConsentUpd(hbciConsent));
            return response;
        }
        catch (HBCI_Exception e) {
            throw HbciErrorUtils.handleHbciException(e);
        }
    }

    private PinTanPassport fetchUpd(HbciDialogRequest dialogRequest, boolean withHktan, Map<String, String> bpd) {
        HBCIUpdDialog dialog = (HBCIUpdDialog)HbciDialogFactory.createDialog(HbciDialogType.UPD, dialogRequest, null, bpd);
        dialog.setWithHktan(withHktan);
        dialog.execute(true);
        return dialog.getPassport();
    }

    private List<GVRTANMediaList.TANMediaInfo> fetchTanMedias(PinTanPassport passport) {
        GVTANMediaList gvtanMediaList = new GVTANMediaList((HBCIPassportInternal)passport);
        HBCIJobsDialog dialog = new HBCIJobsDialog(passport);
        dialog.dialogInit(true, "HKTAB");
        dialog.addTask((AbstractHBCIJob)gvtanMediaList);
        dialog.execute(true);
        return ((GVRTANMediaList)gvtanMediaList.getJobResult()).mediaList();
    }

    private List<TanTransportType> extractTanTransportTypes(PinTanPassport hbciPassport, List<GVRTANMediaList.TANMediaInfo> tanMediaList) {
        return hbciPassport.getUserTwostepMechanisms().stream().map(id -> (HBCITwoStepMechanism)hbciPassport.getBankTwostepMechanisms().get(id)).filter(Objects::nonNull).map(hbciTwoStepMechanism -> TanTransportType.builder().id(hbciTwoStepMechanism.getSecfunc()).name(hbciTwoStepMechanism.getName()).inputInfo(hbciTwoStepMechanism.getInputinfo()).needTanMedia(hbciTwoStepMechanism.getNeedtanmedia().equals("2")).timeoutDecoupledFirstStatusRequest(hbciTwoStepMechanism.getTimeoutDecoupledFirstStatusRequest()).timeoutDecoupledNextStatusRequest(hbciTwoStepMechanism.getTimeoutDecoupledNextStatusRequest()).decoupledMaxStatusRequests(hbciTwoStepMechanism.getMaxDecoupledStatusRequests()).build()).map(tanTransportType -> {
            if (!tanTransportType.isNeedTanMedia()) {
                return Collections.singletonList(tanTransportType);
            }
            return tanMediaList.stream().map(tanMediaInfo -> {
                TanTransportType clone = (TanTransportType)SerializationUtils.clone((Serializable)tanTransportType);
                clone.setMedium(tanMediaInfo.mediaName);
                return clone;
            }).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public HbciScaHandler(HBCIProduct hbciProduct, long sysIdMaxAgeMs, long updMaxAgeMs, HbciBpdCacheHolder hbciBpdCacheHolder) {
        this.hbciProduct = hbciProduct;
        this.sysIdMaxAgeMs = sysIdMaxAgeMs;
        this.updMaxAgeMs = updMaxAgeMs;
        this.hbciBpdCacheHolder = hbciBpdCacheHolder;
    }
}

