package de.adorsys.multibanking.hbci;

import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2022-02-23T18:00:49+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.14 (Azul Systems, Inc.)"
)
class HbciScaMapperImpl implements HbciScaMapper {

    @Override
    public CreateConsentResponse toCreateConsentResponse(HbciConsent bankApiConsentData) {
        if ( bankApiConsentData == null ) {
            return null;
        }

        CreateConsentResponse createConsentResponse = new CreateConsentResponse();

        createConsentResponse.setConsentId( java.util.UUID.randomUUID().toString() );
        createConsentResponse.setAuthorisationId( java.util.UUID.randomUUID().toString() );
        createConsentResponse.setBankApiConsentData( bankApiConsentData );
        createConsentResponse.setScaApproach( ScaApproach.EMBEDDED );

        return createConsentResponse;
    }

    @Override
    public UpdateAuthResponse toUpdateAuthResponse(HbciConsent hbciConsent, UpdateAuthResponse updateAuthResponse) {
        if ( hbciConsent == null ) {
            return null;
        }

        if ( updateAuthResponse.getScaMethods() != null ) {
            List<TanTransportType> list = hbciConsent.getTanMethodList();
            if ( list != null ) {
                updateAuthResponse.getScaMethods().clear();
                updateAuthResponse.getScaMethods().addAll( list );
            }
            else {
                updateAuthResponse.setScaMethods( null );
            }
        }
        else {
            List<TanTransportType> list = hbciConsent.getTanMethodList();
            if ( list != null ) {
                updateAuthResponse.setScaMethods( new ArrayList<TanTransportType>( list ) );
            }
        }
        updateAuthResponse.setBankApiConsentData( hbciConsent );

        return updateAuthResponse;
    }
}
