/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.manager.HBCIProduct;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.passport.PinTanPassport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbciPassport
extends PinTanPassport {
    private static final Logger log = LoggerFactory.getLogger(HbciPassport.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    HbciPassport(String hbciversion, Map<String, String> properties, HBCICallback hbciCallback, HBCIProduct hbciProduct) {
        super(hbciversion, properties, (HBCICallback)(hbciCallback != null ? hbciCallback : new HBCICallbackConsole()), hbciProduct);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class State {
        private HBCIProduct hbciProduct;
        private String hbciVersion;
        private String customerId;
        private String blz;
        private String userId;
        private String country;
        private String host;
        private int port;
        private String sysId;
        private List<String> allowedTwostepMechanisms;
        private HBCITwoStepMechanism currentSecMechInfo;

        public State(PinTanPassport passport) {
            this.country = passport.getCountry();
            this.host = passport.getHost();
            this.port = passport.getPort();
            this.blz = passport.getBLZ();
            this.userId = passport.getUserId();
            this.sysId = passport.getSysId();
            this.hbciVersion = passport.getHBCIVersion();
            this.customerId = passport.getCustomerId();
            this.allowedTwostepMechanisms = passport.getUserTwostepMechanisms();
            this.currentSecMechInfo = passport.getCurrentSecMechInfo();
            this.hbciProduct = passport.getHbciProduct();
        }

        public static State fromJson(String s) {
            try {
                return (State)OBJECT_MAPPER.readValue(s, State.class);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public void apply(HbciPassport passport) {
            passport.setCountry(this.country);
            passport.setHost(this.host);
            passport.setPort(this.port);
            passport.setUserId(this.userId);
            passport.setSysId(this.sysId);
            passport.setCustomerId(this.customerId);
            passport.setUserTwostepMechanisms(new ArrayList<String>(this.allowedTwostepMechanisms));
            passport.setCurrentSecMechInfo(this.currentSecMechInfo);
        }

        public String toJson() {
            try {
                return OBJECT_MAPPER.writeValueAsString((Object)this);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public HBCIProduct getHbciProduct() {
            return this.hbciProduct;
        }

        public String getHbciVersion() {
            return this.hbciVersion;
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getBlz() {
            return this.blz;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getCountry() {
            return this.country;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getSysId() {
            return this.sysId;
        }

        public List<String> getAllowedTwostepMechanisms() {
            return this.allowedTwostepMechanisms;
        }

        public HBCITwoStepMechanism getCurrentSecMechInfo() {
            return this.currentSecMechInfo;
        }

        public void setHbciProduct(HBCIProduct hbciProduct) {
            this.hbciProduct = hbciProduct;
        }

        public void setHbciVersion(String hbciVersion) {
            this.hbciVersion = hbciVersion;
        }

        public void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        public void setBlz(String blz) {
            this.blz = blz;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setSysId(String sysId) {
            this.sysId = sysId;
        }

        public void setAllowedTwostepMechanisms(List<String> allowedTwostepMechanisms) {
            this.allowedTwostepMechanisms = allowedTwostepMechanisms;
        }

        public void setCurrentSecMechInfo(HBCITwoStepMechanism currentSecMechInfo) {
            this.currentSecMechInfo = currentSecMechInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            HBCIProduct this$hbciProduct = this.getHbciProduct();
            HBCIProduct other$hbciProduct = other.getHbciProduct();
            if (this$hbciProduct == null ? other$hbciProduct != null : !this$hbciProduct.equals(other$hbciProduct)) {
                return false;
            }
            String this$hbciVersion = this.getHbciVersion();
            String other$hbciVersion = other.getHbciVersion();
            if (this$hbciVersion == null ? other$hbciVersion != null : !this$hbciVersion.equals(other$hbciVersion)) {
                return false;
            }
            String this$customerId = this.getCustomerId();
            String other$customerId = other.getCustomerId();
            if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
                return false;
            }
            String this$blz = this.getBlz();
            String other$blz = other.getBlz();
            if (this$blz == null ? other$blz != null : !this$blz.equals(other$blz)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$sysId = this.getSysId();
            String other$sysId = other.getSysId();
            if (this$sysId == null ? other$sysId != null : !this$sysId.equals(other$sysId)) {
                return false;
            }
            List<String> this$allowedTwostepMechanisms = this.getAllowedTwostepMechanisms();
            List<String> other$allowedTwostepMechanisms = other.getAllowedTwostepMechanisms();
            if (this$allowedTwostepMechanisms == null ? other$allowedTwostepMechanisms != null : !((Object)this$allowedTwostepMechanisms).equals(other$allowedTwostepMechanisms)) {
                return false;
            }
            HBCITwoStepMechanism this$currentSecMechInfo = this.getCurrentSecMechInfo();
            HBCITwoStepMechanism other$currentSecMechInfo = other.getCurrentSecMechInfo();
            return !(this$currentSecMechInfo == null ? other$currentSecMechInfo != null : !this$currentSecMechInfo.equals(other$currentSecMechInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof State;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            HBCIProduct $hbciProduct = this.getHbciProduct();
            result = result * 59 + ($hbciProduct == null ? 43 : $hbciProduct.hashCode());
            String $hbciVersion = this.getHbciVersion();
            result = result * 59 + ($hbciVersion == null ? 43 : $hbciVersion.hashCode());
            String $customerId = this.getCustomerId();
            result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
            String $blz = this.getBlz();
            result = result * 59 + ($blz == null ? 43 : $blz.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $sysId = this.getSysId();
            result = result * 59 + ($sysId == null ? 43 : $sysId.hashCode());
            List<String> $allowedTwostepMechanisms = this.getAllowedTwostepMechanisms();
            result = result * 59 + ($allowedTwostepMechanisms == null ? 43 : ((Object)$allowedTwostepMechanisms).hashCode());
            HBCITwoStepMechanism $currentSecMechInfo = this.getCurrentSecMechInfo();
            result = result * 59 + ($currentSecMechInfo == null ? 43 : $currentSecMechInfo.hashCode());
            return result;
        }

        public String toString() {
            return "HbciPassport.State(hbciProduct=" + this.getHbciProduct() + ", hbciVersion=" + this.getHbciVersion() + ", customerId=" + this.getCustomerId() + ", blz=" + this.getBlz() + ", userId=" + this.getUserId() + ", country=" + this.getCountry() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", sysId=" + this.getSysId() + ", allowedTwostepMechanisms=" + this.getAllowedTwostepMechanisms() + ", currentSecMechInfo=" + this.getCurrentSecMechInfo() + ")";
        }

        public State() {
        }
    }
}

