/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.FutureSinglePayment;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.hbci.HbciBpdCacheHolder;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVInstantUebSEPA;
import org.kapott.hbci.GV.GVTermUebSEPA;
import org.kapott.hbci.GV.GVUebSEPA;
import org.kapott.hbci.GV_Result.GVRPayment;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class SinglePaymentJob
extends AbstractPaymentJob<SinglePayment> {
    public SinglePaymentJob(TransactionRequest<SinglePayment> transactionRequest, HbciBpdCacheHolder bpdCacheHolder) {
        super(transactionRequest, bpdCacheHolder);
    }

    @Override
    AbstractHBCIJob createHbciJob() {
        Object paymentJob;
        SinglePayment singlePayment = (SinglePayment)this.transactionRequest.getTransaction();
        if (singlePayment instanceof FutureSinglePayment) {
            paymentJob = new GVTermUebSEPA((HBCIPassportInternal)this.dialog.getPassport(), GVTermUebSEPA.getLowlevelName());
            paymentJob.setParam("date", ((FutureSinglePayment)singlePayment).getExecutionDate().toString());
        } else {
            paymentJob = singlePayment.isInstantPayment() ? new GVInstantUebSEPA((HBCIPassportInternal)this.dialog.getPassport(), GVInstantUebSEPA.getLowlevelName()) : new GVUebSEPA((HBCIPassportInternal)this.dialog.getPassport(), GVUebSEPA.getLowlevelName());
        }
        paymentJob.setParam("src", this.getHbciKonto());
        paymentJob.setParam("dst", this.createReceiverAccount(singlePayment));
        paymentJob.setParam("btg", new Value(singlePayment.getAmount(), singlePayment.getCurrency()));
        if (singlePayment.getPurpose() != null) {
            paymentJob.setParam("usage", singlePayment.getPurpose());
        }
        if (singlePayment.getPurposecode() != null) {
            paymentJob.setParam("purposecode", singlePayment.getPurposecode());
        }
        if (singlePayment.getEndToEndId() != null) {
            paymentJob.setParam("endtoendid", singlePayment.getEndToEndId());
        }
        return paymentJob;
    }

    private Konto createReceiverAccount(SinglePayment singlePayment) {
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic();
        return dst;
    }

    @Override
    protected String getHbciJobName() {
        if (((SinglePayment)this.transactionRequest.getTransaction()).getTransactionType() == AbstractTransaction.TransactionType.FUTURE_SINGLE_PAYMENT) {
            return GVTermUebSEPA.getLowlevelName();
        }
        return GVUebSEPA.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return paymentGV instanceof GVRPayment ? ((GVRPayment)paymentGV).getOrderId() : null;
    }
}

