/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.PaymentStatus;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.PaymentStatusResponse;
import de.adorsys.multibanking.domain.transaction.PaymentStatusReqest;
import de.adorsys.multibanking.hbci.HbciBpdCacheHolder;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import org.kapott.hbci.GV.GVInstanstUebSEPAStatus;
import org.kapott.hbci.GV_Result.GVRInstantUebSEPAStatus;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIExecStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantPaymentStatusJob
extends ScaAwareJob<PaymentStatusReqest, PaymentStatusResponse> {
    private static final Logger log = LoggerFactory.getLogger(InstantPaymentStatusJob.class);
    private GVInstanstUebSEPAStatus paymentStatusHbciJob;

    public InstantPaymentStatusJob(TransactionRequest<PaymentStatusReqest> transactionRequest, HbciBpdCacheHolder bpdCacheHolder) {
        super(transactionRequest, bpdCacheHolder);
    }

    public static PaymentStatus mapPaymentStatus(int hbciStatus) {
        PaymentStatus paymentStatus = null;
        switch (hbciStatus) {
            case 1: {
                paymentStatus = PaymentStatus.CANC;
                break;
            }
            case 2: {
                paymentStatus = PaymentStatus.RJCT;
                break;
            }
            case 3: {
                paymentStatus = PaymentStatus.ACTC;
                break;
            }
            case 4: {
                paymentStatus = PaymentStatus.ACSC;
                break;
            }
            case 5: {
                paymentStatus = PaymentStatus.CANC;
                break;
            }
            case 6: {
                paymentStatus = PaymentStatus.RJCT;
                break;
            }
            case 7: {
                paymentStatus = PaymentStatus.ACCC;
                break;
            }
            case 8: {
                paymentStatus = PaymentStatus.RJCT;
                break;
            }
            case 9: {
                paymentStatus = PaymentStatus.RJCT;
                break;
            }
            default: {
                log.warn("unexpected payment status: " + hbciStatus);
            }
        }
        return paymentStatus;
    }

    GVInstanstUebSEPAStatus createHbciJob() {
        this.paymentStatusHbciJob = new GVInstanstUebSEPAStatus((HBCIPassportInternal)this.dialog.getPassport());
        this.paymentStatusHbciJob.setParam("my", this.getHbciKonto());
        this.paymentStatusHbciJob.setParam("orderid", ((PaymentStatusReqest)this.transactionRequest.getTransaction()).getPaymentId());
        return this.paymentStatusHbciJob;
    }

    @Override
    String getHbciJobName() {
        return GVInstanstUebSEPAStatus.getLowlevelName();
    }

    @Override
    void checkExecuteStatus(HBCIExecStatus execStatus) {
    }

    @Override
    public PaymentStatusResponse createJobResponse() {
        GVRInstantUebSEPAStatus hbciStatus = (GVRInstantUebSEPAStatus)this.paymentStatusHbciJob.getJobResult();
        return new PaymentStatusResponse(InstantPaymentStatusJob.mapPaymentStatus(hbciStatus.getStatus()));
    }
}

