/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.RawSepaPayment;
import de.adorsys.multibanking.hbci.HbciBpdCacheHolder;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.kapott.hbci.GV.GVDauerSEPANew;
import org.kapott.hbci.GV.GVInstantUebSEPA;
import org.kapott.hbci.GV.GVRawSEPA;
import org.kapott.hbci.GV.GVUebSEPA;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.sepa.SepaVersion;

public class RawSepaJob
extends AbstractPaymentJob<RawSepaPayment> {
    public RawSepaJob(TransactionRequest<RawSepaPayment> transactionRequest, HbciBpdCacheHolder bpdCacheHolder) {
        super(transactionRequest, bpdCacheHolder);
    }

    @Override
    String getHbciJobName() {
        return GVRawSEPA.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult jobResult) {
        return null;
    }

    GVRawSEPA createHbciJob() {
        String jobName;
        RawSepaPayment sepaPayment = (RawSepaPayment)this.transactionRequest.getTransaction();
        switch (sepaPayment.getSepaTransactionType()) {
            case SINGLE_PAYMENT: {
                jobName = GVUebSEPA.getLowlevelName();
                break;
            }
            case INSTANT_PAYMENT: {
                jobName = GVInstantUebSEPA.getLowlevelName();
                break;
            }
            case BULK_PAYMENT: {
                jobName = "SammelUebSEPA";
                break;
            }
            case STANDING_ORDER: {
                jobName = GVDauerSEPANew.getLowlevelName();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported raw sepa transaction: " + sepaPayment.getSepaTransactionType());
            }
        }
        return this.createRawSepaJob(sepaPayment, jobName);
    }

    private GVRawSEPA createRawSepaJob(RawSepaPayment sepaPayment, String jobName) {
        GVRawSEPA rawSEPAJob = new GVRawSEPA((HBCIPassportInternal)this.dialog.getPassport(), jobName, sepaPayment.getRawRequestData());
        rawSEPAJob.setParam("src", this.getHbciKonto());
        String creditorIban = "";
        BigDecimal amount = new BigDecimal(0);
        String currency = "";
        List<Map<String, String>> result = this.parsePain(sepaPayment.getPainXml());
        for (Map<String, String> resultMap : result) {
            creditorIban = resultMap.get("dst.iban");
            amount = amount.add(NumberUtils.createBigDecimal((String)resultMap.get("value")));
            String tempCurrency = resultMap.get("curr");
            if (currency.length() > 0 && !currency.equals(tempCurrency)) {
                throw new IllegalArgumentException("mixed currencies in bulk payment");
            }
            currency = tempCurrency;
        }
        if (result.size() > 1) {
            rawSEPAJob.setLowlevelParam(rawSEPAJob.getName() + ".sepa.dst.iban", creditorIban);
        }
        rawSEPAJob.setLowlevelParam(rawSEPAJob.getName() + ".sepa.btg.value", amount.toString());
        rawSEPAJob.setLowlevelParam(rawSEPAJob.getName() + ".sepa.btg.curr", currency);
        return rawSEPAJob;
    }

    private List<Map<String, String>> parsePain(String painXml) {
        ArrayList<Map<String, String>> sepaResults = new ArrayList<Map<String, String>>();
        ISEPAParser parser = SEPAParserFactory.get((SepaVersion)SepaVersion.autodetect((String)painXml));
        parser.parse((InputStream)new ByteArrayInputStream(painXml.getBytes(StandardCharsets.UTF_8)), sepaResults);
        return sepaResults;
    }
}

