/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.request.TransactionRequestFactory;
import de.adorsys.multibanking.domain.response.AccountInformationResponse;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.LoadAccounts;
import de.adorsys.multibanking.domain.transaction.LoadBalances;
import de.adorsys.multibanking.hbci.HbciBpdCacheHolder;
import de.adorsys.multibanking.hbci.job.LoadBalancesJob;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.GVSEPAInfo;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountInformationJob
extends ScaAwareJob<LoadAccounts, AccountInformationResponse> {
    private static final Logger log = LoggerFactory.getLogger(AccountInformationJob.class);

    public AccountInformationJob(TransactionRequest<LoadAccounts> transactionRequest, HbciBpdCacheHolder bpdCacheHolder) {
        super(transactionRequest, bpdCacheHolder);
        if (((LoadAccounts)transactionRequest.getTransaction()).isWithBalances()) {
            ((HbciConsent)transactionRequest.getBankApiConsentData()).setCloseDialog(false);
        }
    }

    GVSEPAInfo createHbciJob() {
        if (!this.dialog.getPassport().jobSupported("SEPAInfo")) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, "SEPAInfo job not supported");
        }
        return new GVSEPAInfo((HBCIPassportInternal)this.dialog.getPassport());
    }

    @Override
    String getHbciJobName() {
        return GVSEPAInfo.getLowlevelName();
    }

    @Override
    public AccountInformationResponse createJobResponse() {
        this.transactionRequest.getBankAccess().setBankName(this.dialog.getPassport().getInstName());
        List hbciAccounts = this.dialog.getPassport().getAccounts();
        List result = hbciAccounts.stream().map(konto -> {
            BankAccount bankAccount = accountStatementMapper.toBankAccount(konto);
            bankAccount.externalId(BankApi.HBCI, UUID.randomUUID().toString());
            bankAccount.bankName(this.transactionRequest.getBankAccess().getBankName());
            if (this.getOrCreateHbciJob().getJobResult().isOK() && ((LoadAccounts)this.transactionRequest.getTransaction()).isWithBalances() && konto.allowedGVs.contains("HKSAL")) {
                LoadBalances loadBalances = new LoadBalances();
                loadBalances.setPsuAccount(bankAccount);
                TransactionRequest loadBalancesRequest = TransactionRequestFactory.create((AbstractTransaction)loadBalances, null, (BankAccess)this.transactionRequest.getBankAccess(), (Bank)this.transactionRequest.getBank(), (Object)this.transactionRequest.getBankApiConsentData());
                LoadBalancesJob loadBalancesJob = new LoadBalancesJob((TransactionRequest<LoadBalances>)loadBalancesRequest, this.getHbciBpdCacheHolder());
                loadBalancesJob.dialog = this.dialog;
                loadBalancesJob.execute(null);
            }
            return bankAccount;
        }).collect(Collectors.toList());
        if (this.getOrCreateHbciJob().getJobResult().isOK() && ((LoadAccounts)this.transactionRequest.getTransaction()).isWithBalances()) {
            this.dialog.dialogEnd();
        }
        return AccountInformationResponse.builder().bankAccess(this.transactionRequest.getBankAccess()).bankAccounts(result).build();
    }
}

