/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci;

import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.hbci.HbciBpdCacheHolder;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.callback.AbstractHBCICallback;

public class HbciBpdUpdCallback
extends AbstractHBCICallback {
    private final String bankCode;
    private final HbciBpdCacheHolder hbciBpdCacheHolder;
    private Map<String, String> upd;
    private String sysId;

    public void status(int statusTag, Object o) {
        if (statusTag == 4) {
            this.hbciBpdCacheHolder.updateBpd(this.bankCode, (Map)o);
        } else if (statusTag == 12) {
            this.upd = (Map)o;
        }
    }

    public void callback(int reason, List<String> messages, int datatype, StringBuilder retData) {
        if (reason == 40) {
            throw new MultibankingException(MultibankingError.INVALID_PIN, messages.stream().map(messageString -> {
                if (StringUtils.equals((CharSequence)":", (CharSequence)StringUtils.substring((String)messageString, (int)4, (int)5))) {
                    String hbciCode = StringUtils.substring((String)messageString, (int)0, (int)4);
                    String msg = StringUtils.substring((String)messageString, (int)5);
                    return new Message(hbciCode, null, null, msg, null);
                }
                return new Message(null, null, null, messageString, null);
            }).collect(Collectors.toList()));
        }
    }

    public void status(int statusTag, Object[] o) {
        if (statusTag == 10) {
            this.sysId = o[1].toString();
        }
    }

    public HbciConsent updateConsentUpd(HbciConsent consent) {
        Optional.ofNullable(this.upd).ifPresent(newUpd -> {
            consent.setHbciUpd((Map<String, String>)newUpd);
            consent.setUpdCacheUpdateTime(LocalDateTime.now());
            consent.setSysIdUpdUpdated(true);
        });
        Optional.ofNullable(this.sysId).ifPresent(newSysId -> {
            consent.setHbciSysId((String)newSysId);
            consent.setSysIdCacheUpdateTime(LocalDateTime.now());
            consent.setSysIdUpdUpdated(true);
        });
        return consent;
    }

    public static HbciBpdUpdCallback createCallback(Bank bank, HbciBpdCacheHolder hbciBpdCacheHolder) {
        String bankCode = Optional.ofNullable(bank.getBankApiBankCode()).orElse(bank.getBankCode());
        return new HbciBpdUpdCallback(bankCode, hbciBpdCacheHolder);
    }

    public HbciBpdUpdCallback(String bankCode, HbciBpdCacheHolder hbciBpdCacheHolder) {
        this.bankCode = bankCode;
        this.hbciBpdCacheHolder = hbciBpdCacheHolder;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public HbciBpdCacheHolder getHbciBpdCacheHolder() {
        return this.hbciBpdCacheHolder;
    }

    public Map<String, String> getUpd() {
        return this.upd;
    }

    public String getSysId() {
        return this.sysId;
    }

    public void setUpd(Map<String, String> upd) {
        this.upd = upd;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public String toString() {
        return "HbciBpdUpdCallback(bankCode=" + this.getBankCode() + ", hbciBpdCacheHolder=" + this.getHbciBpdCacheHolder() + ", upd=" + this.getUpd() + ", sysId=" + this.getSysId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HbciBpdUpdCallback)) {
            return false;
        }
        HbciBpdUpdCallback other = (HbciBpdUpdCallback)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$bankCode = this.getBankCode();
        String other$bankCode = other.getBankCode();
        if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
            return false;
        }
        HbciBpdCacheHolder this$hbciBpdCacheHolder = this.getHbciBpdCacheHolder();
        HbciBpdCacheHolder other$hbciBpdCacheHolder = other.getHbciBpdCacheHolder();
        if (this$hbciBpdCacheHolder == null ? other$hbciBpdCacheHolder != null : !this$hbciBpdCacheHolder.equals(other$hbciBpdCacheHolder)) {
            return false;
        }
        Map<String, String> this$upd = this.getUpd();
        Map<String, String> other$upd = other.getUpd();
        if (this$upd == null ? other$upd != null : !((Object)this$upd).equals(other$upd)) {
            return false;
        }
        String this$sysId = this.getSysId();
        String other$sysId = other.getSysId();
        return !(this$sysId == null ? other$sysId != null : !this$sysId.equals(other$sysId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HbciBpdUpdCallback;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $bankCode = this.getBankCode();
        result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
        HbciBpdCacheHolder $hbciBpdCacheHolder = this.getHbciBpdCacheHolder();
        result = result * 59 + ($hbciBpdCacheHolder == null ? 43 : $hbciBpdCacheHolder.hashCode());
        Map<String, String> $upd = this.getUpd();
        result = result * 59 + ($upd == null ? 43 : ((Object)$upd).hashCode());
        String $sysId = this.getSysId();
        result = result * 59 + ($sysId == null ? 43 : $sysId.hashCode());
        return result;
    }
}

