/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.model;

import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.hbci.HbciCacheHandler;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import de.adorsys.multibanking.hbci.model.HbciDialogRequest;
import de.adorsys.multibanking.hbci.model.HbciDialogType;
import de.adorsys.multibanking.hbci.model.HbciPassport;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.dialog.AbstractHbciDialog;
import org.kapott.hbci.dialog.HBCIBpdDialog;
import org.kapott.hbci.dialog.HBCIJobsDialog;
import org.kapott.hbci.dialog.HBCIUpdDialog;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIProduct;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.PinTanPassport;

public final class HbciDialogFactory {
    public static AbstractHbciDialog createDialog(HbciDialogType dialogType, HbciPassport existingPassport, HbciDialogRequest dialogRequest, HBCITwoStepMechanism twoStepMechanism) {
        String bankCode = Optional.ofNullable(dialogRequest.getBank().getBankApiBankCode()).orElse(dialogRequest.getBank().getBankCode());
        BankInfo bankInfo = Optional.ofNullable(HBCIUtils.getBankInfo((String)dialogRequest.getBank().getBankCode())).orElseThrow(() -> new MultibankingException(MultibankingError.BANK_NOT_SUPPORTED, "Bank [" + bankCode + "] not supported"));
        HbciPassport newPassport = Optional.ofNullable(existingPassport).orElseGet(() -> {
            HbciConsent hbciConsent = (HbciConsent)dialogRequest.getBankApiConsentData();
            return HbciDialogFactory.createPassport(bankInfo.getPinTanVersion().getId(), bankCode, hbciConsent.getCredentials().getUserId(), hbciConsent.getCredentials().getCustomerId(), hbciConsent.getHbciProduct(), dialogRequest.getCallback());
        });
        newPassport.setCurrentSecMechInfo(twoStepMechanism);
        Optional.ofNullable(dialogRequest.getBankAccess()).map(BankAccess::getHbciPassportState).ifPresent(state -> HbciPassport.State.fromJson(state).apply(newPassport));
        Optional.ofNullable(HbciCacheHandler.getBpdCache().get(bankCode)).ifPresent(arg_0 -> ((HbciPassport)newPassport).setBPD(arg_0));
        Optional.ofNullable(dialogRequest.getHbciUPD()).ifPresent(arg_0 -> ((HbciPassport)newPassport).setUPD(arg_0));
        Optional.ofNullable(dialogRequest.getHbciSysId()).ifPresent(arg_0 -> ((HbciPassport)newPassport).setSysId(arg_0));
        newPassport.setPIN(((HbciConsent)dialogRequest.getBankApiConsentData()).getCredentials().getPin());
        String url = bankInfo.getPinTanAddress();
        String proxyPrefix = System.getProperty("proxyPrefix", null);
        if (proxyPrefix != null) {
            url = proxyPrefix + url;
        }
        newPassport.setHost(url);
        switch (dialogType) {
            case BPD: {
                return new HBCIBpdDialog((PinTanPassport)newPassport);
            }
            case UPD: {
                return new HBCIUpdDialog((PinTanPassport)newPassport, true);
            }
            case JOBS: {
                return new HBCIJobsDialog((PinTanPassport)newPassport);
            }
        }
        throw new IllegalStateException("Unexpected dialog tpye: " + (Object)((Object)dialogType));
    }

    public static HbciPassport createPassport(HbciPassport.State state, HBCICallback callback) {
        return HbciDialogFactory.createPassport(state.getHbciVersion(), state.getBlz(), state.getCustomerId(), state.getUserId(), state.getHbciProduct(), callback);
    }

    private static HbciPassport createPassport(String hbciVersion, String bankCode, String customerId, String userId, HBCIProduct hbciProduct, HBCICallback callback) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("kernel.rewriter", "InvalidSegment,WrongStatusSegOrder,WrongSequenceNumbers,MissingMsgRef,HBCIVersion,SigIdLeadingZero,InvalidSuppHBCIVersion,SecTypeTAN,KUmsDelimiters,KUmsEmptyBDateSets");
        properties.put("log.loglevel.default", "2");
        properties.put("default.hbciversion", "FinTS3");
        properties.put("client.passport.PinTan.checkcert", "1");
        properties.put("client.passport.PinTan.init", "1");
        properties.put("client.errors.ignoreJobNotSupported", "yes");
        properties.put("client.passport.country", "DE");
        properties.put("client.passport.blz", bankCode);
        properties.put("client.passport.customerId", customerId);
        properties.put("client.errors.ignoreCryptErrors", "yes");
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            properties.put("client.passport.userId", userId);
        }
        return new HbciPassport(hbciVersion, properties, callback, hbciProduct);
    }

    private HbciDialogFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

