/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.util;

import de.adorsys.multibanking.domain.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.status.HBCIStatus;

public final class HbciErrorUtils {
    public static RuntimeException handleHbciException(HBCI_Exception e) {
        Throwable processException = e;
        while (processException.getCause() != null && !(processException.getCause() instanceof MultibankingException)) {
            processException = processException.getCause();
        }
        if (processException.getCause() instanceof MultibankingException) {
            return (MultibankingException)processException.getCause();
        }
        return e;
    }

    public static MultibankingException toMultibankingException(List<HBCIMsgStatus> msgStatusList) {
        return new MultibankingException(MultibankingError.HBCI_ERROR, -1, HbciErrorUtils.msgStatusListToMessages(msgStatusList), null);
    }

    public static MultibankingException toMultibankingException(HBCIStatus hbciStatus) {
        return new MultibankingException(MultibankingError.HBCI_ERROR, -1, HbciErrorUtils.collectMessages(hbciStatus.getRetVals()), null);
    }

    public static List<Message> msgStatusListToMessages(List<HBCIMsgStatus> msgStatusList) {
        return Optional.ofNullable(msgStatusList).map(Collection::stream).orElseGet(Stream::empty).map(HbciErrorUtils::msgStatusToMessages).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<Message> msgStatusToMessages(HBCIMsgStatus msgStatus) {
        return Optional.of(msgStatus).map(status -> Stream.of(status.globStatus.getRetVals(), status.segStatus.getRetVals())).orElseGet(Stream::empty).map(HbciErrorUtils::collectMessages).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<Message> collectMessages(List<HBCIRetVal> hbciReturnValues) {
        return Optional.ofNullable(hbciReturnValues).map(list -> list.stream().map(retVal -> {
            Message.Severity severity = retVal.code.startsWith("9") ? Message.Severity.ERROR : Message.Severity.WARNING;
            return new Message(retVal.code, severity, null, retVal.text, null);
        })).orElse(Stream.empty()).collect(Collectors.toList());
    }

    private HbciErrorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

