/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import org.kapott.hbci.GV.GVUmbSEPA;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferJob
extends AbstractPaymentJob<SinglePayment, GVUmbSEPA> {
    private static final Logger log = LoggerFactory.getLogger(TransferJob.class);

    public TransferJob(TransactionRequest<SinglePayment> transactionRequest) {
        super(transactionRequest);
    }

    GVUmbSEPA createHbciJob() {
        SinglePayment singlePayment = (SinglePayment)this.transactionRequest.getTransaction();
        Konto src = this.getHbciKonto();
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic() != null ? singlePayment.getReceiverBic() : src.bic;
        GVUmbSEPA hbciJob = new GVUmbSEPA((HBCIPassportInternal)this.dialog.getPassport(), GVUmbSEPA.getLowlevelName(), null);
        hbciJob.setParam("src", src);
        hbciJob.setParam("dst", dst);
        hbciJob.setParam("btg", new Value(singlePayment.getAmount(), singlePayment.getCurrency()));
        if (singlePayment.getPurpose() != null) {
            hbciJob.setParam("usage", singlePayment.getPurpose());
        }
        if (singlePayment.getEndToEndId() != null) {
            hbciJob.setParam("endtoendid", singlePayment.getEndToEndId());
        }
        hbciJob.verifyConstraints();
        return hbciJob;
    }

    @Override
    String getHbciJobName() {
        return GVUmbSEPA.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult jobResult) {
        return null;
    }
}

