/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.AbstractRequest;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.domain.response.TransactionAuthorisationResponse;
import de.adorsys.multibanking.domain.transaction.AbstractPayment;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.TransactionAuthorisation;
import de.adorsys.multibanking.hbci.HbciCacheHandler;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciPassport;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import de.adorsys.multibanking.hbci.util.HbciErrorUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.callback.AbstractHBCICallback;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.dialog.HBCIJobsDialog;
import org.kapott.hbci.manager.KnownTANProcess;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionAuthorisationJob<T extends AbstractTransaction, R extends AbstractResponse> {
    private static final Logger log = LoggerFactory.getLogger(TransactionAuthorisationJob.class);
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).findAndRegisterModules();
    private final ScaAwareJob<T, R> scaJob;
    private final TransactionAuthorisation<T> transactionAuthorisation;
    private final HbciConsent consent;
    private final HBCIJobsDialog hbciDialog;

    public TransactionAuthorisationJob(ScaAwareJob<T, R> scaJob, TransactionAuthorisation<T> transactionAuthorisation) {
        this.scaJob = scaJob;
        this.transactionAuthorisation = transactionAuthorisation;
        this.consent = (HbciConsent)transactionAuthorisation.getOriginTransactionRequest().getBankApiConsentData();
        scaJob.hbciTanSubmit = this.evaluateTanSubmit();
        scaJob.dialog = this.hbciDialog = new HBCIJobsDialog((PinTanPassport)this.createPassport(), scaJob.hbciTanSubmit.getDialogId(), scaJob.hbciTanSubmit.getMsgNum());
    }

    public TransactionAuthorisationResponse<R> execute() {
        if (this.scaJob.hbciTanSubmit.getTwoStepMechanism().getProcess() == 1) {
            this.submitProcess1();
        } else {
            this.submitProcess2();
        }
        HBCIExecStatus hbciExecStatus = this.hbciDialog.execute(false);
        if (!hbciExecStatus.isOK()) {
            if (this.consent.isCloseDialog()) {
                this.hbciDialog.dialogEnd();
            }
            throw HbciErrorUtils.toMultibankingException(hbciExecStatus.getMsgStatusList());
        }
        if (StringUtils.equals((CharSequence)"HKIDN", (CharSequence)this.scaJob.hbciTanSubmit.getHbciJobName())) {
            if (!hbciExecStatus.getMsgStatusList().isEmpty()) {
                this.hbciDialog.getPassport().updateUPD((Map)((HBCIMsgStatus)hbciExecStatus.getMsgStatusList().get(0)).getData());
            }
            TransactionAuthorisationResponse response = new TransactionAuthorisationResponse(this.scaJob.execute(null));
            response.setScaStatus(ScaStatus.FINALISED);
            return response;
        }
        if (this.consent.isCloseDialog()) {
            this.hbciDialog.dialogEnd();
        }
        this.scaJob.hbciTanSubmit.setMsgNum(this.scaJob.hbciTanSubmit.getMsgNum() + 1L);
        return this.createResponse(hbciExecStatus);
    }

    private void submitProcess1() {
        AbstractHBCIJob hbciJob = this.scaJob.getOrCreateHbciJob();
        if (this.scaJob.hbciTanSubmit.getSepaPain() != null) {
            hbciJob.getConstraints().remove("_sepapain");
            hbciJob.setLowlevelParam(hbciJob.getName() + ".sepapain", this.scaJob.hbciTanSubmit.getSepaPain());
        }
        this.hbciDialog.addTask(hbciJob);
    }

    private void submitProcess2() {
        AbstractHBCIJob originJob = Optional.ofNullable(this.scaJob.hbciTanSubmit.getOriginJobName()).map(originJobName -> {
            AbstractHBCIJob hbciJob = this.scaJob.getOrCreateHbciJob();
            try {
                hbciJob.setLlParams((Map)objectMapper.readValue(this.scaJob.hbciTanSubmit.getLowLevelParams(), HashMap.class));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new MultibankingException(MultibankingError.INTERNAL_ERROR, 500, e.getMessage());
            }
            hbciJob.setSegVersion(this.scaJob.hbciTanSubmit.getOriginSegVersion());
            return hbciJob;
        }).orElse(null);
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)this.hbciDialog.getPassport(), originJob);
        hktan.setProcess(KnownTANProcess.PROCESS2_STEP2);
        Optional.ofNullable(this.scaJob.hbciTanSubmit.getHbciJobName()).ifPresent(hbciSegCode -> hktan.setParam("ordersegcode", hbciSegCode));
        hktan.setVeu(this.scaJob.hbciTanSubmit.isVeu());
        hktan.setParam("orderref", this.scaJob.hbciTanSubmit.getOrderRef());
        hktan.setParam("process", this.scaJob.hbciTanSubmit.getHktanProcess() != null ? this.scaJob.hbciTanSubmit.getHktanProcess() : "2");
        hktan.setParam("notlasttan", "N");
        this.hbciDialog.addTask((AbstractHBCIJob)hktan, false);
    }

    private TransactionAuthorisationResponse<R> createResponse(HBCIExecStatus hbciExecStatus) {
        R jobResponse = this.scaJob.createJobResponse();
        jobResponse.setMessages(HbciErrorUtils.msgStatusListToMessages(hbciExecStatus.getMsgStatusList()));
        TransactionAuthorisationResponse response = new TransactionAuthorisationResponse(jobResponse);
        ScaStatus scaStatus = Optional.ofNullable(this.scaJob.hbciTanSubmit.getHbciJobName()).map(hbciJobName -> hbciJobName.equals("HKIDN") || this.scaJob.transactionRequest.getTransaction() instanceof AbstractPayment).map(finalised -> Boolean.TRUE.equals(finalised) ? ScaStatus.FINALISED : ScaStatus.SCAMETHODSELECTED).orElse(ScaStatus.FINALISED);
        response.setScaStatus(scaStatus);
        return response;
    }

    private HbciTanSubmit evaluateTanSubmit() {
        if (this.consent.getHbciTanSubmit() instanceof HbciTanSubmit) {
            return (HbciTanSubmit)this.consent.getHbciTanSubmit();
        }
        return this.deserializeTanSubmit((byte[])this.consent.getHbciTanSubmit());
    }

    private HbciTanSubmit deserializeTanSubmit(byte[] data) {
        try {
            return (HbciTanSubmit)objectMapper.readValue(data, HbciTanSubmit.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not deserialize HbciTanSubmit", e);
        }
    }

    private HbciPassport createPassport() {
        Map bpd = Optional.ofNullable(HbciCacheHandler.getBpd((AbstractRequest)this.transactionAuthorisation.getOriginTransactionRequest())).orElseGet(() -> this.scaJob.fetchBpd(null).getBPD());
        HbciPassport.State state = HbciPassport.State.fromJson(this.scaJob.hbciTanSubmit.getPassportState());
        HbciPassport passport = HbciDialogFactory.createPassport(state, (HBCICallback)new AbstractHBCICallback(){

            public String needTAN() {
                return ((HbciConsent)TransactionAuthorisationJob.this.transactionAuthorisation.getOriginTransactionRequest().getBankApiConsentData()).getScaAuthenticationData();
            }
        });
        state.apply(passport);
        HbciConsent hbciConsent = (HbciConsent)this.transactionAuthorisation.getOriginTransactionRequest().getBankApiConsentData();
        passport.setPIN(hbciConsent.getCredentials().getPin());
        passport.setCurrentSecMechInfo(this.scaJob.hbciTanSubmit.getTwoStepMechanism());
        passport.setBPD(bpd);
        return passport;
    }
}

