/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci;

import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.request.AbstractRequest;
import de.adorsys.multibanking.hbci.HbciBpdUpdCallback;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class HbciCacheHandler {
    private static final Map<String, Map<String, String>> bpdCache = new ConcurrentHashMap<String, Map<String, String>>();

    public static Map<String, String> getBpd(AbstractRequest request) {
        String bankCode = Optional.ofNullable(request.getBank().getBankApiBankCode()).orElse(request.getBank().getBankCode());
        return bpdCache.get(bankCode);
    }

    static HbciBpdUpdCallback createCallback(Bank bank) {
        String bankCode = Optional.ofNullable(bank.getBankApiBankCode()).orElse(bank.getBankCode());
        return new HbciBpdUpdCallback(bankCode, bpdCache);
    }

    private HbciCacheHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Map<String, Map<String, String>> getBpdCache() {
        return bpdCache;
    }
}

