/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.LoadBalancesResponse;
import de.adorsys.multibanking.domain.transaction.LoadBalances;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import org.kapott.hbci.GV.GVSaldoReq;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancesJob
extends ScaAwareJob<LoadBalances, LoadBalancesResponse> {
    private static final Logger log = LoggerFactory.getLogger(LoadBalancesJob.class);

    public LoadBalancesJob(TransactionRequest<LoadBalances> transactionRequest) {
        super(transactionRequest);
    }

    GVSaldoReq createHbciJob() {
        GVSaldoReq hbciJob = new GVSaldoReq((HBCIPassportInternal)this.dialog.getPassport());
        hbciJob.setParam("my", this.getHbciKonto());
        return hbciJob;
    }

    @Override
    String getHbciJobName() {
        return GVSaldoReq.getLowlevelName();
    }

    @Override
    public LoadBalancesResponse createJobResponse() {
        if (this.getHbciJob().getJobResult().getJobStatus().hasErrors()) {
            log.error("Balance job not OK");
            throw new MultibankingException(MultibankingError.HBCI_ERROR, this.collectMessages(this.getHbciJob().getJobResult().getJobStatus().getRetVals()));
        }
        BankAccount bankAccount = ((LoadBalances)this.transactionRequest.getTransaction()).getPsuAccount();
        GVRSaldoReq jobResult = (GVRSaldoReq)this.getHbciJob().getJobResult();
        if (jobResult.getEntries() != null && !jobResult.getEntries().isEmpty()) {
            bankAccount.setBalances(accountStatementMapper.createBalancesReport((GVRSaldoReq)this.getHbciJob().getJobResult(), bankAccount.getAccountNumber()));
        }
        return new LoadBalancesResponse(bankAccount);
    }
}

