/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.BulkPayment;
import de.adorsys.multibanking.domain.transaction.FutureBulkPayment;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import org.apache.commons.lang3.BooleanUtils;
import org.kapott.hbci.GV.GVMultiUebSEPA;
import org.kapott.hbci.GV.GVTermMultiUebSEPA;
import org.kapott.hbci.GV.GVUebSEPA;
import org.kapott.hbci.GV_Result.GVRPayment;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class BulkPaymentJob
extends AbstractPaymentJob<BulkPayment, GVUebSEPA> {
    public BulkPaymentJob(TransactionRequest<BulkPayment> transactionRequest) {
        super(transactionRequest);
    }

    GVUebSEPA createHbciJob() {
        GVTermMultiUebSEPA hbciJob;
        BulkPayment bulkPayment = (BulkPayment)this.transactionRequest.getTransaction();
        Konto src = this.getHbciKonto();
        if (bulkPayment instanceof FutureBulkPayment) {
            hbciJob = new GVTermMultiUebSEPA((HBCIPassportInternal)this.dialog.getPassport(), GVTermMultiUebSEPA.getLowlevelName());
            hbciJob.setParam("date", ((FutureBulkPayment)bulkPayment).getExecutionDate().toString());
        } else {
            hbciJob = new GVMultiUebSEPA((HBCIPassportInternal)this.dialog.getPassport(), GVMultiUebSEPA.getLowlevelName());
        }
        hbciJob.setParam("src", src);
        hbciJob.setParam("batchbook", BooleanUtils.isTrue((Boolean)bulkPayment.getBatchbooking()) ? "1" : "0");
        for (int i = 0; i < bulkPayment.getPayments().size(); ++i) {
            SinglePayment payment = (SinglePayment)bulkPayment.getPayments().get(i);
            Konto dst = new Konto();
            dst.name = payment.getReceiver();
            dst.iban = payment.getReceiverIban();
            dst.bic = payment.getReceiverBic();
            hbciJob.setParam("dst", Integer.valueOf(i), dst);
            hbciJob.setParam("btg", Integer.valueOf(i), new Value(payment.getAmount(), payment.getCurrency()));
            if (payment.getPurpose() != null) {
                hbciJob.setParam("usage", Integer.valueOf(i), payment.getPurpose());
            }
            if (payment.getPurposecode() != null) {
                hbciJob.setParam("purposecode", Integer.valueOf(i), payment.getPurposecode());
            }
            if (payment.getEndToEndId() == null) continue;
            hbciJob.setParam("endtoendid", Integer.valueOf(i), payment.getEndToEndId());
        }
        return hbciJob;
    }

    @Override
    protected String getHbciJobName() {
        if (((BulkPayment)this.transactionRequest.getTransaction()).getTransactionType() == AbstractTransaction.TransactionType.FUTURE_BULK_PAYMENT) {
            return "TermMultiUebSEPA";
        }
        return "MultiUebSEPA";
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return paymentGV instanceof GVRPayment ? ((GVRPayment)paymentGV).getOrderId() : null;
    }
}

