/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVUmbSEPA;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferJob
extends AbstractPaymentJob<SinglePayment> {
    private static final Logger log = LoggerFactory.getLogger(TransferJob.class);
    private final TransactionRequest<SinglePayment> transactionRequest;
    private AbstractSEPAGV hbciTransferJob;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        SinglePayment singlePayment = (SinglePayment)this.transactionRequest.getTransaction();
        Konto src = this.getHbciKonto(passport);
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic() != null ? singlePayment.getReceiverBic() : src.bic;
        this.hbciTransferJob = new GVUmbSEPA((HBCIPassportInternal)passport, GVUmbSEPA.getLowlevelName(), null);
        this.hbciTransferJob.setParam("src", src);
        this.hbciTransferJob.setParam("dst", dst);
        this.hbciTransferJob.setParam("btg", new Value(singlePayment.getAmount(), singlePayment.getCurrency()));
        if (singlePayment.getPurpose() != null) {
            this.hbciTransferJob.setParam("usage", singlePayment.getPurpose());
        }
        if (singlePayment.getEndToEndId() != null) {
            this.hbciTransferJob.setParam("endtoendid", singlePayment.getEndToEndId());
        }
        this.hbciTransferJob.verifyConstraints();
        return this.hbciTransferJob;
    }

    @Override
    TransactionRequest<SinglePayment> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        return GVUmbSEPA.getLowlevelName();
    }

    @Override
    AbstractHBCIJob getHbciJob() {
        return this.hbciTransferJob;
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult jobResult) {
        return null;
    }

    public TransferJob(TransactionRequest<SinglePayment> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

