/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.FutureSinglePayment;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVInstantUebSEPA;
import org.kapott.hbci.GV.GVTermUebSEPA;
import org.kapott.hbci.GV.GVUebSEPA;
import org.kapott.hbci.GV_Result.GVRPayment;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class SinglePaymentJob
extends AbstractPaymentJob<SinglePayment> {
    private final TransactionRequest<SinglePayment> transactionRequest;
    private AbstractSEPAGV hbciSinglePaymentJob;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        SinglePayment singlePayment = (SinglePayment)this.transactionRequest.getTransaction();
        Konto src = this.getHbciKonto(passport);
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic();
        if (singlePayment instanceof FutureSinglePayment) {
            this.hbciSinglePaymentJob = new GVTermUebSEPA((HBCIPassportInternal)passport, GVTermUebSEPA.getLowlevelName());
            this.hbciSinglePaymentJob.setParam("date", ((FutureSinglePayment)singlePayment).getExecutionDate().toString());
        } else {
            this.hbciSinglePaymentJob = singlePayment.isInstantPayment() ? new GVInstantUebSEPA((HBCIPassportInternal)passport, GVInstantUebSEPA.getLowlevelName()) : new GVUebSEPA((HBCIPassportInternal)passport, GVUebSEPA.getLowlevelName());
        }
        this.hbciSinglePaymentJob.setParam("src", src);
        this.hbciSinglePaymentJob.setParam("dst", dst);
        this.hbciSinglePaymentJob.setParam("btg", new Value(singlePayment.getAmount(), singlePayment.getCurrency()));
        if (singlePayment.getPurpose() != null) {
            this.hbciSinglePaymentJob.setParam("usage", singlePayment.getPurpose());
        }
        if (singlePayment.getPurposecode() != null) {
            this.hbciSinglePaymentJob.setParam("purposecode", singlePayment.getPurposecode());
        }
        if (singlePayment.getEndToEndId() != null) {
            this.hbciSinglePaymentJob.setParam("endtoendid", singlePayment.getEndToEndId());
        }
        this.hbciSinglePaymentJob.verifyConstraints();
        return this.hbciSinglePaymentJob;
    }

    @Override
    AbstractHBCIJob getHbciJob() {
        return this.hbciSinglePaymentJob;
    }

    @Override
    TransactionRequest<SinglePayment> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    protected String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        if (transactionType == AbstractTransaction.TransactionType.FUTURE_SINGLE_PAYMENT) {
            return GVTermUebSEPA.getLowlevelName();
        }
        return GVUebSEPA.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return paymentGV instanceof GVRPayment ? ((GVRPayment)paymentGV).getOrderId() : null;
    }

    public SinglePaymentJob(TransactionRequest<SinglePayment> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

